% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msc.depth.R
\name{msc.depth}
\alias{msc.depth}
\title{Check the read depth of assembled minicircles}
\usage{
msc.depth(depthstats, groups, HCN = NULL)
}
\arguments{
\item{depthstats}{character vector containing the file names of the depth statistics generated by KOMICS. Each file should be in the format "sample_name.depthstats.txt" (e.g., sampleA.depthstats.txt, sampleB.depthstats.txt,...).}

\item{groups}{a vector specifying the groups (e.g., species) to which the samples belong.}

\item{HCN}{an optional numeric vector containing haploid copy numbers of the corresponding samples. This argument is set to null by default.}
}
\value{
\item{all}{a table that merges the depth statistics of all samples. The table includes the average, median, minimum, and maximum per site read depth.}
\item{plots}{a plot per sample that visualizes the median read depth distribution.}
\item{medianRD}{a graph summarizing the median read depth distribution of all samples.}
\item{CN}{a graph summarizing the copy number (if HCN is not null) of all samples.}
}
\description{
The msc.depth function allows you to analyze the read depth of assembled minicircles using depth statistics generated by KOMICS. These statistics provide information such as the average, median, minimum, and maximum read depth per site for each minicircle contig. By standardizing the median read depths per minicircle contig to the median genome-wide read depths, you can estimate minicircle copy numbers.
}
\examples{
require(ggpubr)
data(exData)

### run function
\donttest{
depth <- msc.depth(depthstats = system.file("extdata", 
                  exData$depthstats, package = "rKOMICS"), groups = exData$species,
                  HCN = exData$medGWD/2)

### visualize results 
hist(depth$all[,"MEDIAN.DEPTH"], breaks=100, 
    main="Global median depth distribution",xlab = (''))

### alter plot 
annotate_figure(depth$plots$CUM29A1, fig.lab = "CUM29A1", 
               fig.lab.pos = "bottom.right", fig.lab.face = 'italic')
}
}
