/*
 * Decompiled with CFR 0.152.
 */
package org.python.jsr223;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.python.Version;
import org.python.core.Py;
import org.python.jsr223.PyScriptEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyScriptEngineFactory
implements ScriptEngineFactory {
    @Override
    public String getEngineName() {
        return "jython";
    }

    @Override
    public String getEngineVersion() {
        return String.format("%s.%s.%s", Version.PY_MAJOR_VERSION, Version.PY_MINOR_VERSION, Version.PY_MICRO_VERSION);
    }

    @Override
    public List<String> getExtensions() {
        return Collections.unmodifiableList(Arrays.asList("py"));
    }

    @Override
    public String getLanguageName() {
        return "python";
    }

    @Override
    public String getLanguageVersion() {
        return String.format("%s.%s", Version.PY_MAJOR_VERSION, Version.PY_MINOR_VERSION);
    }

    @Override
    public Object getParameter(String key) {
        if (key.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equals("javax.script.name")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        if (key.equals("THREADING")) {
            return "MULTITHREADED";
        }
        return null;
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(String.format("%s.%s(", obj, m));
        int i = args.length;
        for (String arg : args) {
            buffer.append(arg);
            if (i-- <= 0) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        StringBuilder buffer = new StringBuilder(toDisplay.length() + 8);
        buffer.append("print ");
        buffer.append(Py.newUnicode(toDisplay).__repr__());
        return buffer.toString();
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuilder buffer = new StringBuilder();
        for (String statement : statements) {
            buffer.append(statement);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new PyScriptEngine(this);
    }

    @Override
    public List<String> getMimeTypes() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<String> getNames() {
        return Collections.unmodifiableList(Arrays.asList("python", "jython"));
    }
}

