% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cprd_import.R
\name{add_to_database}
\alias{add_to_database}
\title{Adds a series of files to a database}
\usage{
add_to_database(db, files, table_name, dateformat = "\%d/\%m/\%Y",
  yob_origin = 1800, practid = TRUE, filenames = FALSE)
}
\arguments{
\item{db}{a database connection object}

\item{files}{a character vector of filenames to files to be imported}

\item{table_name}{a name for the table to import to}

\item{dateformat}{the format that dates are stored in the CPRD data.  If this is wrong it won't break but all dates are likely to be NA}

\item{yob_origin}{value to add yob values to to get actual year of birth (Generally 1800)}

\item{practid}{logical should practice id variable be constructed from the patient ids?}

\item{filenames}{logical should the filename be included as a variable?}
}
\description{
This function can be used to import a CPRD file or files into a SQLite database connection.
}
\details{
Will automatically unzip files before calling them in
If practid is TRUE, a practid variable is constructed by converting the last 3 digits of the patient id (if supplied) to a numeric.
If filenames is TRUE, source data filenames are included as a variable with the filetypes stripped away.
}

