% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{updateAmGaugeChart}
\alias{updateAmGaugeChart}
\title{Update the score of a gauge chart}
\usage{
updateAmGaugeChart(session, outputId, score)
}
\arguments{
\item{session}{the Shiny \code{session} object}

\item{outputId}{the output id passed on to \code{\link{amChart4Output}}}

\item{score}{new value of the score}
}
\description{
Update the score of a gauge chart in a Shiny app
}
\examples{
library(rAmCharts4)
library(shiny)

gradingData <- data.frame(
  label = c("Slow", "Moderate", "Fast"),
  lowScore = c(0, 100/3, 200/3),
  highScore = c(100/3, 200/3, 100)
)


ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      sliderInput(
        "slider", "Score", min = 0, max = 100, value = 30
      )
    ),
    mainPanel(
      amChart4Output("gauge", height = "500px")
    )
  )
)

server <- function(input, output, session){

  output[["gauge"]] <- renderAmChart4({
    amGaugeChart(
      score = isolate(input[["slider"]]),
      minScore = 0, maxScore = 100, gradingData = gradingData,
      theme = "dataviz"
    )
  })

  observeEvent(input[["slider"]], {
    updateAmGaugeChart(session, "gauge", score = input[["slider"]])
  })

}

if(interactive()){
  shinyApp(ui, server)
}
}
