% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_GaugeAxis.R, R/class_GaugeAxis_setters.R
\docType{methods}
\name{initialize,GaugeAxis-method}
\alias{initialize,GaugeAxis-method}
\alias{gaugeAxis}
\alias{setBands}
\alias{setBands,GaugeAxis,list-method}
\alias{addBand}
\alias{addBand,GaugeAxis,GaugeBandOrMissing-method}
\title{Initializes a GaugeAxis}
\usage{
\S4method{initialize}{GaugeAxis}(.Object, axisAlpha = 1, bands, ...)

gaugeAxis(axisAlpha = 1, bands, ...)

setBands(.Object, bands)

\S4method{setBands}{GaugeAxis,list}(.Object, bands)

addBand(.Object, band = NULL, ...)

\S4method{addBand}{GaugeAxis,GaugeBandOrMissing}(.Object, band = NULL,
  ...)
}
\arguments{
\item{.Object}{\linkS4class{GaugeAxis}.}

\item{axisAlpha}{\code{numeric}.}

\item{bands}{\code{list} of \linkS4class{GaugeBand}.
Bands are used to draw color fills between specified values.}

\item{...}{other properties of GaugeAxis.}

\item{band}{\linkS4class{GaugeBand}.
Argument for method \code{addBand}.}
}
\description{
Uses the constructor to create the object
or update an existing one with the setters.
}
\examples{
# --- method initialize
new("GaugeAxis", alpha = 1)

# -- constructor
gaugeAxis()

# -- update 'bands' at once
bands <- list(gaugeBand(startValue = 70, endValue = 90),
              gaugeBand(startValue = 40, endValue = 60))
gaugeAxis(bands = bands)

# --- add 'band' one by one one
addBand(.Object = gaugeAxis(), startValue = 0, endValue = 100)
# equivalent to
gaugeBand_obj <- gaugeBand(startValue = 0, endValue = 100)
addBand(.Object = gaugeAxis(), band = gaugeBand_obj)

}
