/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r;

import com.conveyal.r5.labeling.StreetClass;
import com.conveyal.r5.profile.StreetMode;
import com.conveyal.r5.streets.EdgeStore;
import com.conveyal.r5.streets.VertexStore;
import com.conveyal.r5.transit.TransportNetwork;
import java.util.HashSet;
import org.ipea.r5r.RDataFrame;

public class StreetNetwork {
    public RDataFrame verticesTable;
    public RDataFrame edgesTable;
    private final HashSet<Integer> verticesSet = new HashSet();

    public StreetNetwork(TransportNetwork transportNetwork) {
        this.buildEdgesTable(transportNetwork);
        this.buildVerticesTable(transportNetwork);
    }

    private void buildEdgesTable(TransportNetwork transportNetwork) {
        this.edgesTable = new RDataFrame();
        this.edgesTable.addIntegerColumn("edge_index", 0);
        this.edgesTable.addLongColumn("osm_id", 0L);
        this.edgesTable.addIntegerColumn("from_vertex", 0);
        this.edgesTable.addIntegerColumn("to_vertex", 0);
        this.edgesTable.addStringColumn("street_class", "");
        this.edgesTable.addDoubleColumn("length", 0.0);
        this.edgesTable.addBooleanColumn("walk", false);
        this.edgesTable.addBooleanColumn("car", false);
        this.edgesTable.addDoubleColumn("car_speed", 0.0);
        this.edgesTable.addBooleanColumn("bicycle", false);
        this.edgesTable.addIntegerColumn("bicycle_lts", 0);
        this.edgesTable.addStringColumn("geometry", "");
        EdgeStore edges = transportNetwork.streetLayer.edgeStore;
        EdgeStore.Edge edgeCursor = edges.getCursor();
        while (edgeCursor.advance()) {
            StreetClass streetClass;
            if (edgeCursor.getFlag(EdgeStore.EdgeFlag.LINK)) continue;
            this.edgesTable.append();
            this.edgesTable.set("edge_index", edgeCursor.getEdgeIndex());
            this.edgesTable.set("osm_id", edgeCursor.getOSMID());
            this.edgesTable.set("from_vertex", edgeCursor.getFromVertex());
            this.edgesTable.set("to_vertex", edgeCursor.getToVertex());
            this.edgesTable.set("length", edgeCursor.getLengthM());
            this.edgesTable.set("walk", edgeCursor.allowsStreetMode(StreetMode.WALK));
            byte streetClassCode = edgeCursor.getStreetClassCode();
            switch (edgeCursor.getStreetClassCode()) {
                case 0: {
                    streetClass = StreetClass.MOTORWAY;
                    break;
                }
                case 1: {
                    streetClass = StreetClass.PRIMARY;
                    break;
                }
                case 2: {
                    streetClass = StreetClass.SECONDARY;
                    break;
                }
                case 3: {
                    streetClass = StreetClass.TERTIARY;
                    break;
                }
                default: {
                    streetClass = StreetClass.OTHER;
                }
            }
            this.edgesTable.set("street_class", streetClass.toString());
            this.edgesTable.set("car", edgeCursor.allowsStreetMode(StreetMode.CAR));
            this.edgesTable.set("car_speed", Double.valueOf(edgeCursor.getSpeedKph()));
            int lts = 1;
            if (edgeCursor.getFlag(EdgeStore.EdgeFlag.BIKE_LTS_2)) {
                lts = 2;
            }
            if (edgeCursor.getFlag(EdgeStore.EdgeFlag.BIKE_LTS_3)) {
                lts = 3;
            }
            if (edgeCursor.getFlag(EdgeStore.EdgeFlag.BIKE_LTS_4)) {
                lts = 4;
            }
            this.edgesTable.set("bicycle", edgeCursor.allowsStreetMode(StreetMode.BICYCLE));
            this.edgesTable.set("bicycle_lts", lts);
            this.edgesTable.set("geometry", edgeCursor.getGeometry().toString());
            this.verticesSet.add(edgeCursor.getFromVertex());
            this.verticesSet.add(edgeCursor.getToVertex());
        }
    }

    private void buildVerticesTable(TransportNetwork transportNetwork) {
        this.verticesTable = new RDataFrame();
        this.verticesTable.addIntegerColumn("index", 0);
        this.verticesTable.addDoubleColumn("lat", 0.0);
        this.verticesTable.addDoubleColumn("lon", 0.0);
        this.verticesTable.addBooleanColumn("park_and_ride", false);
        this.verticesTable.addBooleanColumn("bike_sharing", false);
        VertexStore vertices = transportNetwork.streetLayer.vertexStore;
        VertexStore.Vertex vertexCursor = vertices.getCursor();
        this.verticesSet.forEach(v -> {
            vertexCursor.seek(v.intValue());
            this.verticesTable.append();
            this.verticesTable.set("index", vertexCursor.index);
            this.verticesTable.set("lat", vertexCursor.getLat());
            this.verticesTable.set("lon", vertexCursor.getLon());
            this.verticesTable.set("park_and_ride", vertexCursor.getFlag(VertexStore.VertexFlag.PARK_AND_RIDE));
            this.verticesTable.set("bike_sharing", vertexCursor.getFlag(VertexStore.VertexFlag.BIKE_SHARING));
        });
    }
}

