% Generated by roxygen2 (4.0.1): do not edit by hand
\name{SS_changepars}
\alias{SS_changepars}
\title{Change parameters in the control file.}
\usage{
SS_changepars(dir = "C:/myfiles/mymodels/myrun/",
  ctlfile = "control.ss_new", newctlfile = "control_modified.ss",
  linenums = NULL, strings = NULL, newvals = NULL, repeat.vals = FALSE,
  estimate = FALSE, verbose = TRUE)
}
\arguments{
\item{dir}{Directory with control file to change.}

\item{ctlfile}{Control file name. Default="control.ss_new".}

\item{newctlfile}{Name of new control file to be written.
Default="control_modified.ss".}

\item{linenums}{Line numbers of control file to be modified. Either this or
the Strings input are needed. Default=NULL.}

\item{strings}{Strings (with optional partial matching) indicating which
parameters to be modified. This is an alternative to linenums.  Strings
correspond to the commented parameter names included in control.ss_new, or
whatever is written as comment at the end of the 14 number parameter lines.
Default=NULL.}

\item{newvals}{Vector of new parameter values. Default=NULL.}

\item{repeat.vals}{If multiple parameter lines match criteria, repeat the
\code{newvals} input for each line}

\item{estimate}{Vector of TRUE/FALSE for which changed parameters are to be
estimated. Default=FALSE.}

\item{verbose}{More detailed output to command line. Default=TRUE.}
}
\description{
A function to take advantage of \code{\link{SS_parlines}} that could be used
to create a series of control files with different parameter values. This is
used by \code{\link{SS_profile}}, but may also be useful for simulation
work.
}
\examples{
\dontrun{
SS_changepars(dir='Y:/ss/SSv3.03a/Simple/',ctlfile='Control.SS_New',
              strings=c('SR_steep','SR_sigmaR'),newvals=c(.35,.6))
# [1] wrote new file to Control_Modified.SS
#    oldvals newvals oldphase newphase     comment
# 1 0.609048    0.35        4       -4  # SR_steep
# 2 0.600000    0.60       -4       -4 # SR_sigmaR
}
}
\author{
Ian Taylor
}
\seealso{
\code{\link{SS_parlines}}, \code{\link{SS_profile}}
}
\keyword{data}
\keyword{manip}

