% Generated by roxygen2 (4.0.1): do not edit by hand
\name{sel.line}
\alias{sel.line}
\title{a function for drawing selecitivity curves}
\usage{
sel.line(x, model, sp, min.dist, max.dist)
}
\arguments{
\item{x}{vector of x values (age or length)}

\item{model}{selectivity model "Double_Normal" or "Double_Logistic"}

\item{sp}{vector of parameters}

\item{min.dist}{minimum value for selectivity}

\item{max.dist}{maximum value for selectivity}
}
\description{
This function is primarily inteded for use by the selfit function.
}
\examples{
\dontrun{
plot(0, xlim = c(0, 50), ylim = c(0, 1),
xlab = 'Length', ylab = 'Selectivity', type = 'n',
xaxs = 'i', yaxs = 'i')
sel.line(model = 'Double_Normal', min.dist = 10, max.dist = 50,
sp = c(25, -0.5, 3, 3, -5, 0))
}
}
\author{
Tommy Garrison
}
\seealso{
\code{\link{selfit}}
}
\keyword{dplot}

