% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOVA.R
\name{ANOVA}
\alias{ANOVA}
\alias{print.ANOVASPSS}
\alias{plot.ANOVASPSS}
\title{One-way and Two-way ANOVA}
\usage{
ANOVA(data, variable, group, conf.level = 0.95)

\method{print}{ANOVASPSS}(x, digits = 3, statistics = c("descriptives", "variance", "test"), ...)

\method{plot}{ANOVASPSS}(x, y, which = 1, type = "o", main = NULL, xlab = NULL, ylab = NULL, ...)
}
\arguments{
\item{data}{a data frame containing the variables.}

\item{variable}{a character string specifying the numeric variable of
interest.}

\item{group}{a character vector specifying one or two grouping variables.}

\item{conf.level}{a number between 0 and 1 giving the confidence level of
the confidence interval.}

\item{x}{an object of class \code{"ANOVASPSS"} as returned by function
\code{ANOVA}.}

\item{digits}{an integer giving the number of digits after the comma to be
printed in the LaTeX tables.}

\item{statistics}{a character vector specifying which LaTeX tables should
be printed.  Available options are \code{"descriptives"} for descriptive
statistics, \code{"variance"} for Levene's test on homogeneity of the
variances, and \code{"test"} for ANOVA results.  The default is to print all
tables.}

\item{\dots}{For the \code{plot} method, additional arguments to be passed
down, in particular graphical parameters (see also \code{\link{linesSPSS}}).
For the \code{print} method, additional arguments are currently ignored.}

\item{y}{ignored (only included because it is defined for the generic
function \code{\link[graphics]{plot}}).}

\item{which}{for two-way ANOVA, an integer with possible values \code{1} or
\code{2} indicating whether the first or the second factor should be used on
the \eqn{x}-axis.  The other factor will then be used for drawing separate
lines.  For one-way ANOVA, this is not meaningful and ignored.}

\item{type}{a character string specifying the type of lines.  Possible
values are \code{"o"} (the default) for overplotted points and lines, and
\code{"l"} for lines only.}

\item{main, xlab, ylab}{the plot title and axis labels.}
}
\value{
An object of class \code{"ANOVASPSS"} with the following components:
\describe{
  \item{\code{descriptives}}{a data frame containing per-group descriptive
  statistics.}
  \item{\code{levene}}{an object as returned by
  \code{\link[car]{leveneTest}}.}
  \item{\code{test}}{a data frame containing the ANOVA table.}
  \item{\code{variable}}{a character string containing the name of the
  numeric variable of interest.}
  \item{\code{group}}{a character vector containing the name(s) of the
  grouping variable(s).}
  \item{\code{i}}{an integer giving the number of groups in the (first)
  grouping variable.}
  \item{\code{j}}{an integer giving the number of groups in the second
  grouping variable (only two-way ANOVA).}
  \item{\code{conf.level}}{numeric; the confidence level used.}
  \item{\code{type}}{a character string giving the type of ANOVA performed
  (\code{"one-way"} or \code{"two-way"}).}
}

The \code{print} method produces a LaTeX table that mimics the look of SPSS
output (version <24).

The \code{plot} method does not return anything, but produces a profile plot
of the ANOVA results.
}
\description{
Perform one-way or two-way ANOVA on variables of a data set.  The output is
printed as a LaTeX table that mimics the look of SPSS output (version <24),
and a plot of the results mimics the look of SPSS graphs.
}
\examples{
# load data
data("Eredivisie")
# log-transform market values
Eredivisie$logMarketValue <- log(Eredivisie$MarketValue)

# one-way ANOVA
oneway <- ANOVA(Eredivisie, "logMarketValue",
                group = "Position")
oneway        # print LaTeX table
plot(oneway)  # create profile plot

# two-way ANOVA
twoway <- ANOVA(Eredivisie, "logMarketValue",
                group = c("Position", "Foreign"))
twoway        # print LaTeX table
plot(twoway)  # create profile plot

}
\author{
Andreas Alfons
}
\keyword{htest}
