% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assemble.R
\name{assemble_docx}
\alias{assemble_docx}
\title{Assemble Multiple RTF Table Listing and Figure Into One Word Document}
\usage{
assemble_docx(input, output, landscape = FALSE)
}
\arguments{
\item{input}{Character vector of file path.}

\item{output}{Character string to the output file path.}

\item{landscape}{Logical vector to determine page direction.}
}
\description{
The function assemble multiple RTF table, listing, and figures into
one document as Microsoft Word (i.e., \code{docx}).
}
\section{Specification}{

\if{latex}{
  \itemize{
    \item Transfer files to toggle fields format in Word
    \item Insert into Word file using officer
  }
}
\if{html}{
The contents of this section are shown in PDF user manual only.
}
}

\examples{

library(officer)
library(magrittr)

file <- replicate(2, tempfile(fileext = ".rtf"))
file1 <- head(iris) \%>\%
  rtf_body() \%>\%
  rtf_encode() \%>\%
  write_rtf(file[1])
file2 <- head(cars) \%>\%
  rtf_page(orientation = "landscape") \%>\%
  rtf_body() \%>\%
  rtf_encode() \%>\%
  write_rtf(file[2])
output <- tempfile(fileext = ".docx")

assemble_docx(
  input = file,
  output = output
)

}
