% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_arg.R
\name{match_arg}
\alias{match_arg}
\title{Argument Verification Using Partial Matching}
\usage{
match_arg(arg, choices, several.ok = FALSE)
}
\arguments{
\item{arg}{a character vector (of length one unless \code{several.ok}
    is \code{TRUE}) or \code{NULL}.}

\item{choices}{a character vector of candidate values}

\item{several.ok}{logical specifying if \code{arg} should be allowed
    to have more than one element.}
}
\value{
The matched elements of arg or in case of match failure a detailed error message
}
\description{
Similar to \code{match.arg()}, match_arg matches \code{arg} against a table of candidate values as specified by \code{choices}.
}
\details{
This function resolves errors from \code{match.arg()} with '' as arg input.
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Convert arg and choices inputs from numeric to characters.
   \item Input choices imputation if it is missing.
   \item Input arg imputation if it is NULL.
   \item Input several.ok check for arg length.
   \item Compare arg with choices values and report error message if it does not match.
 }
 }
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
\dontrun{
match_arg(arg = c(2, 1), choices = c(4, 3, 1, 2), several.ok = TRUE)
match_arg(arg = c("c", "b"), choices = c("a", "b", "c", "d"), several.ok = TRUE)
}

}
