/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.dmg.pmml.PMML;
import org.jpmml.model.MetroJAXBUtil;
import org.jpmml.rexp.Converter;
import org.jpmml.rexp.ConverterFactory;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RExpParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    @Parameter(names={"--converter"}, description="Converter class")
    private String converter = null;
    @Parameter(names={"--help"}, description="Show the list of configuration options and exit", help=true)
    private boolean help = false;
    @Parameter(names={"--model-rds-input", "--rds-input"}, description="RDS input file", required=true)
    private File input = null;
    @Parameter(names={"--pmml-output"}, description="PMML output file", required=true)
    private File output = null;
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        JCommander commander = new JCommander((Object)main);
        commander.setProgramName(Main.class.getName());
        try {
            commander.parse(args);
        }
        catch (ParameterException pe) {
            StringBuilder sb = new StringBuilder();
            sb.append(pe.toString());
            sb.append("\n");
            commander.usage(sb);
            System.err.println(sb.toString());
            System.exit(-1);
        }
        if (main.help) {
            StringBuilder sb = new StringBuilder();
            commander.usage(sb);
            System.out.println(sb.toString());
            System.exit(0);
        }
        main.run();
    }

    public void run() throws Exception {
        PMML pmml;
        Converter<RExp> converter;
        Class<?> clazz;
        long end;
        RExp rexp;
        long begin;
        try (FileInputStream is = new FileInputStream(this.input);){
            logger.info("Parsing RDS..");
            RExpParser parser = new RExpParser(is);
            begin = System.currentTimeMillis();
            rexp = parser.parse();
            end = System.currentTimeMillis();
            logger.info("Parsed RDS in {} ms.", (Object)(end - begin));
        }
        catch (Exception e) {
            logger.error("Failed to parse RDS", (Throwable)e);
            throw e;
        }
        ConverterFactory converterFactory = ConverterFactory.newInstance();
        if (this.converter != null) {
            logger.info("Initializing user-specified Converter {}", (Object)this.converter);
            clazz = Class.forName(this.converter);
            converter = converterFactory.newConverter(clazz, rexp);
        } else {
            logger.info("Initializing default Converter");
            converter = converterFactory.newConverter(rexp);
        }
        clazz = converter.getClass();
        logger.info("Initialized {}", (Object)clazz.getName());
        try {
            logger.info("Converting..");
            begin = System.currentTimeMillis();
            pmml = converter.encodePMML();
            end = System.currentTimeMillis();
            logger.info("Converted in {} ms.", (Object)(end - begin));
        }
        catch (Exception e) {
            logger.error("Failed to convert", (Throwable)e);
            throw e;
        }
        try (FileOutputStream os = new FileOutputStream(this.output);){
            logger.info("Marshalling PMML..");
            long begin2 = System.currentTimeMillis();
            MetroJAXBUtil.marshalPMML((PMML)pmml, (OutputStream)os);
            long end2 = System.currentTimeMillis();
            logger.info("Marshalled PMML in {} ms.", (Object)(end2 - begin2));
        }
        catch (Exception e) {
            logger.error("Failed to marshal PMML", (Throwable)e);
            throw e;
        }
    }

    public String getConverter() {
        return this.converter;
    }

    public void setConverter(String converter) {
        this.converter = converter;
    }

    public File getInput() {
        return this.input;
    }

    public void setInput(File input) {
        if (input == null) {
            throw new NullPointerException();
        }
        this.input = input;
    }

    public File getOutput() {
        return this.output;
    }

    public void setOutput(File output) {
        if (output == null) {
            throw new NullPointerException();
        }
        this.output = output;
    }
}

