% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vlogs_diff.R
\name{vlogs_diff}
\alias{vlogs_diff}
\title{Create Mean Standardized Differences from Logarithmic Viral Load Data}
\usage{
vlogs_diff(vl_data)
}
\arguments{
\item{vl_data}{A data frame of longitudinal viral load values per individual, where rows represent patients and columns represent sequential measurements across time (e.g., years or visits).}
}
\value{
An object of class \code{"Interaction"} with the following components:
\describe{
\item{vlogs3_diff}{Mean standardized differences of logarithmic viral load values.}
}
}
\description{
This function calculates the mean standardized differences of logarithmic viral loads across time for each individual in the dataset.
}
\examples{
data(vl_3)
vl_data <- vl_3[,-1]
result <- vlogs_diff(vl_data)
}
