% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_payoffs.R
\name{estimate_payoffs}
\alias{estimate_payoffs}
\title{Estimate Payoff Parameters for HIV Phenotype Interactions}
\usage{
estimate_payoffs(object, predictions)
}
\arguments{
\item{object}{An object of class \code{InteractionClassification} containing
the data on viral load differences and CD4 counts.}

\item{predictions}{A \code{data.frame} containing predictions of viral loads or CD4 values.}
}
\description{
This function estimates the payoff parameters for HIV phenotype interactions
based on the provided classification object and predictions from a viral
load model. It calculates the mean differences in viral loads and CD4 counts,
as well as the average payoffs for each classification.
}
\examples{
set.seed(42)
data(cd_3)
cd_data <- cd_3[,-1]
cd_result <- cds_diff(cd_data)
data(vl_3)
vl_data <- vl_3[,-1]
vl_result <- vlogs_diff(vl_data)
result <- InteractionClassification(cd_result = cd_result, vl_result = vl_result)
data(preds)
payoffs_results <- estimate_payoffs(result, preds)
}
