#' Print Method for InteractionClassification Objects
#'
#' This method prints a summary of the InteractionClassification object,
#' including the number of clusters, the cluster means, and the sizes of
#' each cluster.
#'
#' @param x An object of class \code{InteractionClassification} containing
#'   the results of the k-means clustering.
#' @param ... Additional arguments that may be passed to the print method.
#'
#' @return The function does not return a value; it prints the summary
#'   information to the console.
#' @export
#'
#' @examples
#' data(vl_3)
#' data(cd_3)
#' interaction_obj <- create_interactions(cd_3[,-1], vl_3[,-1])
#' class_obj <- InteractionClassification(interaction_obj$vlogs_diff, interaction_obj$cds_diff)
#' 
#' # Print the summary of the classification
#' print(class_obj)
print.InteractionClassification <- function(x, ...) {
  cat("Interaction Classification Summary\n")
  cat("---------------------------------\n")
  cat("Number of clusters:", x$k, "\n\n")
  
  cat("Cluster means:\n")
  print(x$centers)
  
  cat("\nCluster sizes:\n")
  print(table(x$data$classification))
}