% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2d.R
\name{extract_hexbin_centroids}
\alias{extract_hexbin_centroids}
\title{Extract hexagonal bin centroids coordinates and the corresponding standardize counts.}
\usage{
extract_hexbin_centroids(centroids_df, counts_df)
}
\arguments{
\item{centroids_df}{A data frame contains all hexagonal bin centroid
coordinates with hexagon IDs.}

\item{counts_df}{A data frame contains hexagon IDs with the standardize
number of points within each hexagon.}
}
\value{
A data frame contains hexagon ID, centroid coordinates, and standardize counts.
}
\description{
Extract hexagonal bin centroids coordinates and the corresponding standardize counts.
}
\examples{
num_bins_list <- calc_bins(data = s_curve_noise_umap_scaled, x = "UMAP1",
y = "UMAP2", hex_size = NA, buffer_x = NA, buffer_y = NA)
num_bins_x <- num_bins_list$num_x
num_bins_y <- num_bins_list$num_y
hb_obj <- hex_binning(data = s_curve_noise_umap_scaled,
x = "UMAP1", y = "UMAP2", num_bins_x = num_bins_x,
num_bins_y = num_bins_y, x_start = NA, y_start = NA, buffer_x = NA,
buffer_y = NA, hex_size = NA, col_start = "UMAP")
all_centroids_df <- as.data.frame(do.call(cbind, hb_obj$centroids))
counts_df <- as.data.frame(do.call(cbind, hb_obj$std_cts))
extract_hexbin_centroids(centroids_df = all_centroids_df, counts_df = counts_df)

}
