#' Lake Data for \code{quickmapr} examples
#' 
#' This example data is a SpatialPolygonsDataFrame 
#' of a single lake, Lake Sunapee.
#' 
#' @docType data
#' @keywords datasets
#' @format SpatialPolygonDataframe with 1 lakes, each with 13 variables
#'         
#' @name lake

NULL

#' Elevation Data for \code{quickmapr} examples
#' 
#' This example data is a RasterLayer of the National 
#' Elevation Dataset for a buffer of Lake Sunapee.
#' 
#' @docType data
#' @keywords datasets
#' @format RasterLayer of 455 x 246 and 30 meter resolution
#' @name elev

NULL

#' Land Cover Data for \code{quickmapr} examples
#' 
#' This example data is a RasterLayer of the National 
#' Land Cover Dataset for a buffer of Lake Sunapee.
#' 
#' @docType data
#' @keywords datasets
#' @format RasterLayer of 467 x 262 and 30 meter resolution
#' @name nlcd

NULL

#' Point data for \code{quickmapr} examples
#' 
#' This is a fabricated point dataset for what might be a common type of data
#' collected for a lake.
#' 
#' @docType data
#' @keywords datasets
#' @format SpatialPointsDataFrame
#' @name samples

NULL

#' Buffer of Lake Sunapee for \code{quickmapr} examples
#' 
#' This example data is a SpatialPolygonsDataFrame representing a buffer
#' of a single lake, Lake Sunapee.
#' 
#' @docType data
#' @keywords datasets
#' @format SpatialPolygonsDataFrame
#' @name buffer

NULL

#' Maximum Lake Length line for \code{quickmapr} examples
#' 
#' This example data is a line dataset representing the maximum lake length.
#' 
#' @docType data
#' @keywords datasets
#' @format SpatialLines
#' @name length

NULL

#' Maximum lake width for \code{quickmapr} examples
#' 
#' This example data is a line dataset representing the maximum lake width.
#' Maximum lake width is defined as the longest line perpendciular to the
#' maximum lake length.
#' 
#' @docType data
#' @keywords datasets
#' @format SpatialLines
#' @name width

NULL

#' Lakes from the National Lakes Morphometry Dataset for \code{quickmapr} 
#' examples
#' 
#' This example data is a polygon dataset of many lakes in New Hampshire.  Data
#' for each lake are from the first version of the 
#' \href{https://edg.epa.gov/metadata/catalog/search/resource/details.page?uuid=\%7B7DF16BCC-F72D-422F-B5CE-4886AAC6109C\%7D}{National Lakes Morphometry 
#' Dataset}.
#' 
#' @docType data
#' @keywords datasets
#' @format SpatialPolygonsDataFrame
#' @name examp_lakes

NULL

#' Samples points for \code{quickmapr} examples
#' 
#' This example data is a fabricated point dataset with data for each location.
#' 
#' @docType data
#' @keywords datasets
#' @format SpatialPointsDataFrame
#' @name samples

NULL 
