% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describes_functions.R
\name{props_test}
\alias{props_test}
\title{Test for Multiple Sample Proportion Against Pi (Chi-square Tests of Goodness
of Fit)}
\usage{
props_test(
  data,
  dum.nm,
  pi = 0.5,
  yates = TRUE,
  ci.level = 0.95,
  rtn.table = TRUE,
  check = TRUE
)
}
\arguments{
\item{data}{data.frame of data.}

\item{dum.nm}{character vector of length 1 specifying the colnames in
\code{data} of the variables used to calculate the proportions. The
variables must only have values of 0 or 1 (or missing values), or be
otherwise known as dummy variables. See \code{\link[str2str]{is.dummy}}.}

\item{pi}{numeric vector of length = \code{length(dum.nm)} or length 1
specifying the population proportion values to compare the sample
proportions against. The order of the values should be the same as the
order in \code{dum.nm}. When length 1, the same population proportion value
is used for all the variables.}

\item{yates}{logical vector of length 1 specifying whether the Yate's
continuity correction should be applied for small samples. See
\code{\link[stats]{chisq.test}} for details.}

\item{ci.level}{numeric vector of length 1 specifying the confidence level.
\code{ci.level} must range from 0 to 1.}

\item{rtn.table}{logical vector of lengh 1 specifying whether the return
object should include the rbinded 1x2 contingency table of counts with
totals and the rbinded 1x2 overall percentages table. If TRUE, then the
last two elements of the return object are "count" containing a data.frame
of counts and "percent" containing a data.frame of overall percentages.}

\item{check}{logical vector of length 1 specifying whether the input
arguments should be checked for errors. For example, if \code{data[dum.nm]}
are all dummy variables that only take on values of 0 or 1 (or missing
values). This is a tradeoff between computational efficiency (FALSE) and
more useful error messages (TRUE).}
}
\value{
list of data.frames containing statistical information about the
  proportion differences from pi: 1) nhst = chi-square test of goodness of fit
  stat info in a data.frame, 2) desc = descriptive statistics stat info in a
  data.frame, 3) std = various standardized effect sizes in a data.frame,
  4) count = data.frame containing the rbinded 1x2 tables of counts with an additional
  column for the total (if \code{rtn.table} = TRUE), 5) percent = data.frame
  containing the rbinded 1x2 tables of overall percentages with an additional
  column for the total (if \code{rtn.table} = TRUE)

1) nhst = chi-square test of goodness of fit stat info in a data.frame

\describe{
   \item{est}{proportion difference estimate (i.e., sample proportion - pi)}
   \item{se}{NA (to remind the user there is no standard error for the test)}
   \item{X2}{chi-square value}
   \item{df}{degrees of freedom (will always be 1)}
   \item{p}{two-sided p-value}
}

2) desc = descriptive statistics stat info in a data.frame

\describe{
   \item{prop}{sample proportion}
   \item{pi}{popularion proportion provided by the user (or 0.50 by default)}
   \item{sd}{standard deviation}
   \item{n}{sample size}
   \item{lwr}{lower bound of the confidence interval of the sample proportion itself}
   \item{upr}{upper bound of the confidence interval of the sample proportion itself}
}

3) std = various standardized effect sizes in a data.frame

\describe{
   \item{cramer}{Cramer's V estimate}
   \item{h}{Cohen's h estimate}
}

4) count = data.frame containing the rbinded 1x2 tables of counts with an additional
column for the total (if \code{rtn.table} = TRUE). The colnames are 1.
"0", 2. "1", 3. "total"

5) percent = data.frame containing the rbinded 1x2 tables of overall percentages
with an additional column for the total (if \code{rtn.table} = TRUE). The
colnames are 1. "0", 2. "1", 3. "total"
}
\description{
\code{props_test} tests for multiple sample proportion difference from
population proportions with chi-square tests of goodness of fit. The default
is that the goodness of fit is consistent with a population proportion Pi of
0.50. The function also calculates the descriptive statistics, various
standardized effect sizes (e.g., Cramer's V), and can provide the 1x2
contingency tables. \code{props_test} is simply a wrapper for
\code{\link[stats]{prop.test}} plus some extra calculations.
}
\examples{

# multiple variables
mtcars2 <- mtcars
mtcars2$"gear_dum" <- ifelse(mtcars2$"gear" > 3, yes = 1L, no = 0L)
mtcars2$"carb_dum" <- ifelse(mtcars2$"carb" > 3, yes = 1L, no = 0L)
vrb_nm <- c("am","gear_dum","carb_dum") # dummy variables
lapply(X = vrb_nm, FUN = function(nm) {
   table(mtcars2[nm])
})
props_test(data = mtcars2, dum.nm = c("am","gear_dum","carb_dum"))
props_test(data = mtcars2, dum.nm = c("am","gear_dum","carb_dum"),
   rtn.table = FALSE)

# single variable
props_test(data = mtcars2, dum.nm = "am")
props_test(data = mtcars2, dum.nm = "am", rtn.table = FALSE)

# error from non-dummy variables
\dontrun{
props_test(data = mtcars2, dum.nm = c("am","gear","carb"))
}

}
\seealso{
\code{\link[stats]{prop.test}} the workhorse for \code{prop_test},
   \code{\link{prop_test}} for a single dummy variables,
   \code{\link{props_diff}} for chi-square tests of independence,
}
