% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispersal_kernels.R
\name{k_lognormal}
\alias{k_lognormal}
\title{Dispersal kernels for log-normal distance distributions}
\usage{
k_lognormal(x, par, N = 1, d = NCOL(x))
}
\arguments{
\item{x}{Numeric matrix of positions \eqn{x} relative to the seed source,
or vector of distances \eqn{\left\|{x}\right\|} to the seed source.}

\item{par}{Numeric vector with two elements representing log-transformed
scale and shape parameters, given by the median distance \eqn{a} and by
the variance \eqn{b} of the underlying normal distribution.}

\item{N}{The multiplier \eqn{N}.}

\item{d}{The spatial dimension.}
}
\value{
Numeric vector of function values \eqn{k(x)} multiplied by \eqn{N}.
}
\description{
\code{k_lognormal} computes the value, multiplied by \eqn{N}, of a dispersal
kernel based on seeds having a distance with a log-normal distribution
from the their source.
}
\details{
The dispersal kernel, i.e. spatial probability density
of the location of a seed relative to its source, is here given by
\deqn{k(x)={\Gamma (d/2) \over
  2\pi ^{d/2}\left\|{x}\right\|^{d}\sqrt{2\pi b}}
  e^{-{1 \over 2b}(\log (\left\|{x}\right\|/a))^{2}}
  ={\Gamma (d/2)e^{d^{2}b/2} \over 2\pi ^{d/2}a^{d}\sqrt{2\pi b}}
  e^{-{1 \over 2b}(\log {\left\|{x}\right\| \over a}+db)^{2}},}
which corresponds to a probability density of the distance given by
\deqn{p(r)={1 \over r\sqrt{2\pi b}}e^{-{1 \over 2b}(\log (r/a))^{2}}
  ={e^{b/2} \over a\sqrt{2\pi b}}
  e^{-{1 \over 2b}(\log {r \over a}+b)^{2}},}
where \eqn{d} is the spatial dimension, \eqn{\left\|{\,}\right\|}
denotes the Euclidean norm and the normalizing constant of the kernel
involves the \link[base:gamma]{gamma} function; see Greene and Johnson
(1989), Stoyan and Wagner (2001) for the planar case. Thus, the distance
is assumed to have the \link[stats:Lognormal]{log-normal distribution}
such that the log-distance has a normal distribution with mean
\eqn{\log a} and variance \eqn{b}. Here \eqn{\log k(x)} is a quadratic
function of \eqn{\log \left\|{x}\right\|} with a maximum at
\eqn{\log a-db}, while \eqn{\log p(r)} is a quadratic function of
\eqn{\log r} with a maximum at \eqn{\log a-b}.

This kernel is particularly suitable if the maximum regeneration density
is not directly at the seed source (e.g. Janzen–Connell effect), cf.
Nathan et al. (2012).
}
\examples{
k_lognormal(2:5, par=c(0,0), d=2)
}
\references{
Greene, D.F., Johnson, E.A. (1989). A model of wind dispersal of winged or
plumed seeds. \emph{Ecology} \strong{70}(2), 339–347.
\doi{10.2307/1937538}

Stoyan, D., Wagner, S. (2001). Estimating the fruit dispersion of
anemochorous forest trees. \emph{Ecol. Modell.} \strong{145}, 35–47.
\doi{10.1016/S0304-3800(01)00385-4}

Nathan, R., Klein, E., Robledo‐Arnuncio, J.J., Revilla, E. (2012).
Dispersal kernels: review, in Clobert, J., Baguette, M., Benton, T.G.,
Bullock, J.M. (eds.), \emph{Dispersal ecology and evolution}, 186–210.
\doi{10.1093/acprof:oso/9780199608898.003.0015}
}
