% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Class-SmoothedPG.R
\docType{methods}
\name{getCoherencySdNaive-SmoothedPG}
\alias{getCoherencySdNaive,SmoothedPG-method}
\alias{getCoherencySdNaive-SmoothedPG}
\title{Get estimates for the standard deviation of the coherency computed from
smoothed quantile periodogram.}
\usage{
\S4method{getCoherencySdNaive}{SmoothedPG}(object, frequencies = 2 * pi *
  (0:(lenTS(object@qPG@freqRep@Y) - 1))/lenTS(object@qPG@freqRep@Y),
  levels.1 = getLevels(object, 1), levels.2 = getLevels(object, 2),
  d1 = 1:(dim(object@values)[2]), d2 = 1:(dim(object@values)[4]),
  type = c("1", "2"), impl = c("R", "C"))
}
\arguments{
\item{object}{\code{\link{SmoothedPG}} of which to get the estimates for the
standard deviation.}

\item{frequencies}{a vector of frequencies for which to get the result}

\item{levels.1}{the first vector of levels for which to get the result}

\item{levels.2}{the second vector of levels for which to get the result}

\item{d1}{optional parameter that determine for which j1 to return the
data; may be a vector of elements 1, ..., D}

\item{d2}{same as d1, but for j2}

\item{type}{can be "1", where cov(Z, Conj(Z)) is subtracted, or "2", where
it's not}

\item{impl}{choose "R" or "C" for one of the two implementations available}
}
\value{
Returns the estimate described above.
}
\description{
Determines and returns an array of dimension \code{[J,K1,K2]},
where \code{J=length(frequencies)}, \code{K1=length(levels.1)}, and
\code{K2=length(levels.2))}. Whether
available or not, boostrap repetitions are ignored by this procedure.
At position \code{(j,k1,k2)}
the returned value is the standard deviation estimated corresponding to
\code{frequencies[j]}, \code{levels.1[k1]} and \code{levels.2[k2]} that are
closest to the
\code{frequencies}, \code{levels.1} and \code{levels.2}
available in \code{object}; \code{\link{closest.pos}} is used to determine
what closest to means.
}
\details{
If not only one, but multiple time series are under study, the dimension of
the returned vector is of dimension \code{[J,P,K1,P,K2]}, where \code{P}
denotes the dimension of the time series.

Requires that the \code{\link{SmoothedPG}} is available at all Fourier
frequencies from \eqn{(0,\pi]}{(0,pi]}. If this is not the case the missing
values are imputed by taking one that is available and has a frequency
that is closest to the missing Fourier frequency; \code{closest.pos} is used
to determine which one this is.

A precise definition on how the standard deviations of the smoothed quantile
periodogram are estimated is given in Barunik and Kley (2015). The estimate
returned is denoted by
\eqn{\sigma(\tau_1, \tau_2; \omega)}{sigma(tau1, tau2; omega)} on p. 26 of
the arXiv preprint.

Note the ``standard deviation'' estimated here is not the square root of the
complex-valued variance. It's real part is the square root of the variance
of the real part of the estimator and the imaginary part is the square root
of the imaginary part of the variance of the estimator.
}
\references{
Kley, T., Volgushev, S., Dette, H. & Hallin, M. (2014).
Quantile Spectral Processes: Asymptotic Analysis and Inference.
\url{http://arxiv.org/abs/1401.8104}.

Barunik, J. & Kley, T. (2015).
Quantile Cross-Spectral Measures of Dependence between Economic Variables.
[preprint available from the authors]
}
\keyword{Access-functions}

