# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Workhorse function for \code{\link{getSdNaive-SmoothedPG}}.
#'
#' C++ implementation to increase performance.
#'
#' @name .computeSdNaive
#'
#' @keywords internals
#'
#' @param V a 3-dimensional array of complex numbers; dimensions are
#'          \code{[N, K1, K2]}, where \code{N} frequencies are
#'          \eqn{\omega_j := 2\pi j/N} for \eqn{j=0,\ldots,N}.
#' @param W a vector of length \code{W} of length \code{N} used for smoothing.
#'
#' @return Returns an array with complex numbers
#'         \eqn{\sigma(\tau_1, \tau_2, \omega_j} as defined in
#'         Kley et. al (2014), p. 26.
#'
#' @references
#' Kley, T., Volgushev, S., Dette, H. & Hallin, M. (2014).
#' Quantile Spectral Processes: Asymptotic Analysis and Inference.
#' \url{http://arxiv.org/abs/1401.8104}.
NULL

.computeSdNaive <- function(V, W) {
    .Call('quantspec_computeSdNaive', PACKAGE = 'quantspec', V, W)
}

