% Generated by roxygen2 (4.0.2.9000): do not edit by hand
% Please edit documentation in R/aux-functions.R
\name{closest.pos}
\alias{closest.pos}
\title{Positions of elements which are closest to some reference elements.}
\usage{
closest.pos(X, Y)
}
\arguments{
\item{X}{Vector of elements among which to find the closest one for each
element in \code{Y}.}

\item{Y}{Vector of elements for which to find the clostest element in \code{X}.}
}
\value{
Returns a vector of same length as \code{X}, with indices indicating
        which element in \code{Y} is closest.
}
\description{
For two vectors \code{X} and \code{Y} a vector of indices \code{I} is returned,
such that \code{length(Y)} and \code{length(I)} coincide and \code{X[I[j]]}
is an element of \code{X} which has minimal distance to \code{Y[j]}, for all
\code{j=1,\ldots,length(Y)}.
In case that there are multiple elements with minimal distance, the smallest
index (the index of the first element with minimal distance) is returned.
}
\examples{
X1 <- c(1,2,3)
closest.pos(X1, 1.7)
closest.pos(X1, c(1.3,2.2))

X2 <- c(2,1,3)
closest.pos(X2, 1.5)
}

