% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\docType{data}
\name{data_corpus_dailnoconf1991}
\alias{data_corpus_dailnoconf1991}
\title{Confidence debate from 1991 Irish Parliament}
\format{\code{data_corpus_dailnoconf1991} is a corpus with 58 texts, 
  including docvars for \code{name}, \code{party}, and \code{position}.}
\source{
\url{https://www.oireachtas.ie/en/debates/debate/dail/1991-10-16/10/}
}
\usage{
data_corpus_dailnoconf1991
}
\description{
Texts of speeches from a no-confidence motion debated in the Irish Dáil from
16-18 October 1991 over the future of the Fianna Fail-Progressive Democrat
coalition. (See Laver and Benoit 2002 for details.)
}
\examples{
\dontrun{
data_dfm_dailnoconf1991 <- dfm(data_corpus_dailnoconf1991, remove_punct = TRUE)
tmod <- textmodel_affinity(data_dfm_dailnoconf1991, 
                           c("Govt", "Opp", "Opp", rep(NA, 55)))
(pred <- predict(tmod))
dat <- 
    data.frame(party = as.character(docvars(data_corpus_dailnoconf1991, "party")),
               govt = coef(pred)[, "Govt"],
               position = as.character(docvars(data_corpus_dailnoconf1991, "position")),
               stringsAsFactors = FALSE)
bymedian <- with(dat, reorder(paste(party, position), govt, median))
par(mar = c(5, 6, 4, 2)+.1)
boxplot(govt ~ bymedian, data = dat,
        horizontal = TRUE, las = 1,
        xlab = "Degree of support for government")
abline(h = 7.5, col = "red", lty = "dashed")
text(c(0.9, 0.9), c(8.5, 6.5), c("Goverment", "Opposition"))
}
}
\references{
Laver, M. & Benoit, K.R. (2002). 
  \href{https://kenbenoit.net/pdfs/Laver_Benoit_IPS_2002.pdf}{Locating 
  TDs in Policy Spaces: Wordscoring Dáil Speeches}. \emph{Irish Political 
  Studies}, 17(1), 59--73.

Laver, M., Benoit, K.R., & Garry, J. (2003). 
  \href{https://kenbenoit.net/pdfs/WORDSCORESAPSR.pdf}{Estimating Policy 
  Positions from Political Text using Words as Data}. \emph{American
  Political Science Review}, 97(2), 311--331.
}
\keyword{data}
