% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokens.R
\name{tokens}
\alias{tokens}
\title{tokenize a set of texts}
\usage{
tokens(x, what = c("word", "sentence", "character", "fastestword",
  "fasterword"), removeNumbers = FALSE, removePunct = FALSE,
  removeSymbols = FALSE, removeSeparators = TRUE, removeTwitter = FALSE,
  removeHyphens = FALSE, removeURL = FALSE, ngrams = 1L, skip = 0L,
  concatenator = "_", simplify = FALSE, hash = TRUE, verbose = FALSE,
  ...)
}
\arguments{
\item{x}{a character or \link{corpus} object to be tokenized}

\item{what}{the unit for splitting the text, available alternatives are: 
\describe{ \item{\code{"word"}}{(recommended default) smartest, but 
slowest, word tokenization method; see 
\link[stringi]{stringi-search-boundaries} for details.} 
\item{\code{"fasterword"}}{dumber, but faster, word tokenization method, 
uses \code{{\link[stringi]{stri_split_charclass}(x, "\\\\p{WHITE_SPACE}")}}} 
\item{\code{"fastestword"}}{dumbest, but fastest, word tokenization method,
calls \code{\link[stringi]{stri_split_fixed}(x, " ")}} 
\item{\code{"character"}}{tokenization into individual characters} 
\item{\code{"sentence"}}{sentence segmenter, smart enough to handle some 
exceptions in English such as "Prof. Plum killed Mrs. Peacock." (but far 
from perfect).} }}

\item{removeNumbers}{remove tokens that consist only of numbers, but not 
words that start with digits, e.g. \code{2day}}

\item{removePunct}{if \code{TRUE}, remove all characters in the Unicode 
"Punctuation" [P] class}

\item{removeSymbols}{if \code{TRUE}, remove all characters in the Unicode 
"Symbol" [S] class}

\item{removeSeparators}{remove Separators and separator characters (spaces 
and variations of spaces, plus tab, newlines, and anything else in the 
Unicode "separator" category) when \code{removePunct=FALSE}.  Only 
applicable for \code{what = "character"} (when you probably want it to be 
\code{FALSE}) and for \code{what = "word"} (when you probably want it to be
\code{TRUE}).  Note that if \code{what = "word"} and you set 
\code{removePunct = TRUE}, then \code{removeSeparators} has no effect.  Use
carefully.}

\item{removeTwitter}{remove Twitter characters \code{@} and \code{#}; set to
\code{TRUE} if you wish to eliminate these.}

\item{removeHyphens}{if \code{TRUE}, split words that are connected by 
hyphenation and hyphenation-like characters in between words, e.g. 
\code{"self-storage"} becomes \code{c("self", "storage")}.  Default is 
\code{FALSE} to preserve such words as is, with the hyphens.  Only applies 
if \code{what = "word"}.}

\item{removeURL}{if \code{TRUE}, find and eliminate URLs beginning with 
http(s) -- see section "Dealing with URLs".}

\item{ngrams}{integer vector of the \emph{n} for \emph{n}-grams, defaulting 
to \code{1} (unigrams). For bigrams, for instance, use \code{2}; for 
bigrams and unigrams, use \code{1:2}.  You can even include irregular 
sequences such as \code{2:3} for bigrams and trigrams only.  See 
\code{\link{tokens_ngrams}}.}

\item{skip}{integer vector specifying the skips for skip-grams, default is 0 
for only immediately neighbouring words. Only applies if \code{ngrams} is 
different from the default of 1.  See \code{\link{tokens_skipgrams}}.}

\item{concatenator}{character to use in concatenating \emph{n}-grams, default
is "\code{_}", which is recommended since this is included in the regular 
expression and Unicode definitions of "word" characters}

\item{simplify}{no longer active: `tokens()` always returns a tokens object, 
whose basic structure is a list (even for a single document)}

\item{hash}{if \code{TRUE} (default), return a hashed tokens object, 
otherwise, return a classic \code{tokenizedTexts} object.  (This will be 
phased out soon in coming versions.)}

\item{verbose}{if \code{TRUE}, print timing messages to the console; off by 
default}

\item{...}{additional arguments not used}
}
\value{
\pkg{quanteda} \code{tokens} class object, by default a hashed list 
  of integers corresponding to a vector of types.
}
\description{
Tokenize the texts from a character vector or from a corpus.
}
\details{
The tokenizer is designed to be fast and flexible as well as to 
  handle Unicode correctly. Most of the time, users will construct \link{dfm}
  objects from texts or a corpus, without calling \code{tokens()} as an 
  intermediate step.  Since \code{tokens()} is most likely to be used by more
  technical users, we have set its options to default to minimal 
  intervention. This means that punctuation is tokenized as well, and that 
  nothing is removed by default from the text being tokenized except 
  inter-word spacing and equivalent characters.
}
\section{Dealing with URLs}{
 URLs are tricky to tokenize, because they contain
  a number of symbols and punctuation characters.  If you wish to remove 
  these, as most people do, and your text contains URLs, then you should set 
  \code{what = "fasterword"} and \code{removeURL = TRUE}.  If you wish to 
  keep the URLs, but do not want them mangled, then your options are more 
  limited, since removing punctuation and symbols will also remove them from 
  URLs.  We are working on improving this behaviour.
  
  See the examples below.
}

\examples{
txt <- c(doc1 = "This is a sample: of tokens.",
         doc2 = "Another sentence, to demonstrate how tokens works.")
tokens(txt)
# removing punctuation marks and lowecasing texts
tokens(char_tolower(txt), removePunct = TRUE)
# keeping versus removing hyphens
tokens("quanteda data objects are auto-loading.", removePunct = TRUE)
tokens("quanteda data objects are auto-loading.", removePunct = TRUE, removeHyphens = TRUE)
# keeping versus removing symbols
tokens("<tags> and other + symbols.", removeSymbols = FALSE)
tokens("<tags> and other + symbols.", removeSymbols = TRUE)
tokens("<tags> and other + symbols.", removeSymbols = FALSE, what = "fasterword")
tokens("<tags> and other + symbols.", removeSymbols = TRUE, what = "fasterword")

## examples with URLs - hardly perfect!
txt <- "Repo https://githib.com/kbenoit/quanteda, and www.stackoverflow.com."
tokens(txt, removeURL = TRUE, removePunct = TRUE)
tokens(txt, removeURL = FALSE, removePunct = TRUE)
tokens(txt, removeURL = FALSE, removePunct = TRUE, what = "fasterword")
tokens(txt, removeURL = FALSE, removePunct = FALSE, what = "fasterword")


## MORE COMPARISONS
txt <- "#textanalysis is MY <3 4U @myhandle gr8 #stuff :-)"
tokens(txt, removePunct = TRUE)
tokens(txt, removePunct = TRUE, removeTwitter = TRUE)
#tokens("great website http://textasdata.com", removeURL = FALSE)
#tokens("great website http://textasdata.com", removeURL = TRUE)

txt <- c(text1="This is $10 in 999 different ways,\\n up and down; left and right!", 
         text2="@kenbenoit working: on #quanteda 2day\\t4ever, http://textasdata.com?page=123.")
tokens(txt, verbose = TRUE)
tokens(txt, removeNumbers = TRUE, removePunct = TRUE)
tokens(txt, removeNumbers = FALSE, removePunct = TRUE)
tokens(txt, removeNumbers = TRUE, removePunct = FALSE)
tokens(txt, removeNumbers = FALSE, removePunct = FALSE)
tokens(txt, removeNumbers = FALSE, removePunct = FALSE, removeSeparators = FALSE)
tokens(txt, removeNumbers = TRUE, removePunct = TRUE, removeURL = TRUE)

# character level
tokens("Great website: http://textasdata.com?page=123.", what = "character")
tokens("Great website: http://textasdata.com?page=123.", what = "character", 
         removeSeparators = FALSE)

# sentence level         
tokens(c("Kurt Vongeut said; only assholes use semi-colons.", 
           "Today is Thursday in Canberra:  It is yesterday in London.", 
           "Today is Thursday in Canberra:  \\nIt is yesterday in London.",
           "To be?  Or\\nnot to be?"), 
          what = "sentence")
tokens(data_char_inaugural[c(2,40)], what = "sentence")

# removing features (stopwords) from tokenized texts
txt <- char_tolower(c(mytext1 = "This is a short test sentence.",
                      mytext2 = "Short.",
                      mytext3 = "Short, shorter, and shortest."))
tokens(txt, removePunct = TRUE)
### removeFeatures(tokens(txt, removePunct = TRUE), stopwords("english"))

# ngram tokenization
### tokens(txt, removePunct = TRUE, ngrams = 2)
### tokens(txt, removePunct = TRUE, ngrams = 2, skip = 1, concatenator = " ")
### tokens(txt, removePunct = TRUE, ngrams = 1:2)
# removing features from ngram tokens
### removeFeatures(tokens(txt, removePunct = TRUE, ngrams = 1:2), stopwords("english"))
}
\seealso{
\code{\link{tokens_ngrams}}, \code{\link{tokens_skipgrams}}
}
\keyword{tokens}
