% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converters.R
\name{convert}
\alias{as.DocumentTermMatrix}
\alias{as.DocumentTermMatrix.dfm}
\alias{as.wfm}
\alias{as.wfm.dfm}
\alias{convert}
\alias{convert.dfm}
\alias{dfm2ldaformat}
\alias{dfm2ldaformat.dfm}
\alias{quantedaformat2dtm}
\alias{quantedaformat2dtm.dfm}
\title{convert a dfm to a non-quanteda format}
\usage{
convert(x, to, ...)

\method{convert}{dfm}(x, to = c("lda", "tm", "stm", "austin", "topicmodels"),
  docvars = NULL, ...)

as.wfm(x)

\method{as.wfm}{dfm}(x)

as.DocumentTermMatrix(x, ...)

\method{as.DocumentTermMatrix}{dfm}(x, ...)

dfm2ldaformat(x)

\method{dfm2ldaformat}{dfm}(x)

quantedaformat2dtm(x)

\method{quantedaformat2dtm}{dfm}(x)
}
\arguments{
\item{x}{dfm to be converted}

\item{to}{target conversion format, consisting of the name of the package
into whose document-term matrix representation the dfm will be converted: 
\describe{ \item{\code{"lda"}}{a list with components "documents" and
"vocab" as needed by \link[lda]{lda.collapsed.gibbs.sampler} from the
\pkg{lda} package} \item{\code{"tm"}}{a \link[tm]{DocumentTermMatrix} from
the \pkg{tm} package} \item{\code{"stm"}}{the  format for the \pkg{stm}
package} \item{\code{"austin"}}{the \code{wfm} format from the
\strong{austin} package} \item{\code{"topicmodels"}}{the "dtm" format as
used by the \pkg{topicmodels} package} }}

\item{...}{not used here}

\item{docvars}{optional data.frame of document variables used as the
\code{meta} information in conversion to the STM package format.  This aids
in selecting the document variables only corresponding to the documents
with non-zero counts.}
}
\value{
A converted object determined by the value of \code{to} (see above). 
  See conversion target package documentation for more detailed descriptions 
  of the return formats.

\code{dfm2ldaformat} returns a list with components "documents" and "vocab" as needed by 
  \code{\link[lda]{lda.collapsed.gibbs.sampler}}.

\code{quantedaformat2dtm} returns a "dtm" sparse matrix object for use with the 
\pkg{topicmodels} package.
}
\description{
Convert a quanteda \link{dfm-class} object to a format useable by other text
analysis packages.  The general function \code{convert} provides easy
conversion from a dfm to the document-term representations used in all other
text analysis packages for which conversions are defined.  To make the usage
as consistent as possible with other packages, however, quanteda also
provides direct conversion functions in the idiom of the foreign packages,
for example  \code{as.wfm} to coerce a dfm into the \code{wfm} format from
the \strong{austin} package, and \code{quantedaformat2dtm} for using a dfm
with the \pkg{topicmodels} package.
}
\details{
We recommend using \code{convert()} rather than the specific functions.  In
fact, it's worth considering whether we should simply remove all of them and
\strong{only} support calling these through `convert()`.

We may also use this function, eventually, for converting other classes of
objects such as a `corpus` or `tokenizedList`.

\code{as.wfm} converts a quanteda \link{dfm} into the
\code{wfm} format used by the \code{austin} package.

\code{as.DocumentTermMatrix} will convert a quanteda \link{dfm} into
  the \pkg{tm} package's \link[tm]{DocumentTermMatrix} format.

\code{dfm2ldaformat} provides converts a \link{dfm} into the list representation
of terms in documents used by tghe \pkg{lda} package.

\code{quantedaformat2dtm} provides converts a \link{dfm} into the sparse simple triplet matrix
 representation
of terms in documents used by the \pkg{topicmodels} package.
}
\note{
The \pkg{tm} package version of \code{as.TermDocumentMatrix} allows a \code{weighting} argument,
which supplies a weighting function for 
  \link[tm]{TermDocumentMatrix}.  Here the default is for term frequency weighting.
  If you want a different weighting, apply the weights after converting using one of the \pkg{tm}
  functions.
}
\examples{
mycorpus <- subset(inaugCorpus, Year > 1970)
quantdfm <- dfm(mycorpus, verbose = FALSE)

# austin's wfm format
austindfm <- as.wfm(quantdfm)
identical(austindfm, convert(quantdfm, to = "austin"))

# tm's DocumentTermMatrix format
tmdfm <- as.DocumentTermMatrix(quantdfm)
str(tmdfm)

# stm package format
stmdfm <- convert(quantdfm, to = "stm")
str(stmdfm)
# illustrate what happens with zero-length documents
quantdfm2 <- dfm(c(punctOnly = "!!!", mycorpus[-1]), verbose = FALSE)
rowSums(quantdfm2)
stmdfm2 <- convert(quantdfm2, to = "stm", docvars = docvars(mycorpus))
str(stmdfm2)
 
# topicmodels package format
topicmodelsdfm <- quantedaformat2dtm(quantdfm)
identical(topicmodelsdfm, convert(quantdfm, to = "topicmodels"))

# lda package format
ldadfm <- convert(quantdfm, to = "lda")
str(ldadfm)
identical(ldadfm[1], stmdfm[1])

# calling dfm2ldaformat directly
ldadfm <- dfm2ldaformat(quantdfm)
str(ldadfm)
}

