% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus.R
\name{nsentence}
\alias{nsentence}
\alias{nsentence.character}
\alias{nsentence.corpus}
\title{count the number of sentences}
\usage{
nsentence(x, ...)

\method{nsentence}{character}(x, ...)

\method{nsentence}{corpus}(x, ...)
}
\arguments{
\item{x}{texts or corpus whose sentences will be counted}

\item{...}{additional arguments passed to \code{\link{tokenize}}}
}
\value{
scalar count(s) of the total sentences per text
}
\description{
Return the count of sentences in a corpus or character.
}
\note{
`nsentence()` relies on the boundaries definitions in the \pkg{stringi}
  package (see \link[stringi]{stri_opts_brkiter}).  It does not count
  sentences correctly if the text has been transformed to lower case, and for
  this reason `nsentence()` will stop with an error if it detects all
  lower-cased text.
}
\examples{
# simple example
txt <- c(text1 = "This is a sentence: second part of first sentence.",
         text2 = "A word. Repeated repeated.")
nsentence(txt)
}

