% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm-weighting.R
\docType{methods}
\name{tf}
\alias{tf}
\alias{tf,dfm-method}
\title{compute (weighted) term frequency from a dfm}
\usage{
tf(x, scheme = c("count", "prop", "propmax", "boolean", "log", "augmented",
  "logave"), base = 10, K = 0.5)

\S4method{tf}{dfm}(x, scheme = c("count", "prop", "propmax", "boolean", "log",
  "augmented", "logave"), base = 10, K = 0.5)
}
\arguments{
\item{x}{object for which idf or tf-idf will be computed (a document-feature 
matrix)}

\item{scheme}{divisor for the normalization of feature frequencies by document.  Valid types include:
\describe{
\item{\code{unity}}{default, each feature count will remain as feature counts, 
equivalent to dividing by 1}
\item{\code{total}}{total number of features per document, so that the sum of the normalized feature
values is 1.0}
\item{\code{maxCount}}{maximum feature count per document}}}

\item{base}{base for the logarithm when \code{scheme} is \code{"log"} or \code{logave}}

\item{K}{the K for the augmentation when \code{scheme = "augmented"}}
}
\value{
A document feature matrix to which the weighting scheme has been applied.
}
\description{
Apply varieties of term frequency weightings to a \link{dfm}.
}
\details{
\code{tf} is a shortcut to compute relative term frequecies (identical to 
\code{\link{weight}(x, "relFreq")}).
}
\author{
Paul Nulty and Kenneth Benoit
}
\references{
Manning, C. D., Raghavan, P., & Schutze, H. (2008). 
  \emph{Introduction to Information Retrieval}. Cambridge University Press.

\url{https://en.wikipedia.org/wiki/Tf-idf#Term_frequency_2}
}

