% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/settings.R
\name{settings}
\alias{print.settings}
\alias{settings}
\alias{settings.corpus}
\alias{settings.default}
\alias{settings.dfm}
\alias{settings<-}
\title{Get or set the corpus settings}
\usage{
settings(x, ...)

\method{settings}{default}(x = NULL, ...)

\method{settings}{corpus}(x, field = NULL, ...)

settings(x, field) <- value

\method{settings}{dfm}(x, ...)

\method{print}{settings}(x, ...)
}
\arguments{
\item{x}{object from/to which settings are queried or applied}

\item{...}{additional arguments}

\item{field}{string containing the name of the setting to be set or queried
\code{settings(x)}  query the corps settings

\code{settings(x, field) <-}  update the corpus settings for \code{field}}

\item{value}{new setting value}
}
\description{
Get or set the corpus settings

Get or set various settings in the corpus for the treatment of texts, such as rules for
stemming, stopwords, collocations, etc.

Get the settings from a which a \link{dfm} was created
}
\details{
Calling \code{settings()} with no arguments returns a list of system default settings.
}
\examples{
settings(inaugCorpus, "stopwords")
(tempdfm <- dfm(subset(inaugCorpus, Year>1980), verbose=FALSE))
(tempdfmSW <- dfm(subset(inaugCorpus, Year>1980),
                 ignoredFeatures=stopwords("english"), verbose=FALSE))
settings(inaugCorpus, "stopwords") <- TRUE
tempdfm <- dfm(inaugCorpus, stem=TRUE, verbose=FALSE)
settings(tempdfm)
}

