% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QUALYPSOSS.r
\name{get.matrix.Winv}
\alias{get.matrix.Winv}
\title{get.matrix.Winv 
return the inverse matrix of W = V x C x V for the treatment of heteroscedastic and AR(1) errors
see Wang (2011) section 5.3 for further details}
\usage{
get.matrix.Winv(weight.hetero, nMO, nP, rho)
}
\arguments{
\item{weight.hetero}{output of \code{\link{get.vec.weight.hetero}}}

\item{nMO}{number of possible simulation chains (missing and non-missing)}

\item{nP}{number of continuous predictors (e.g. future times)}

\item{rho}{AR(1) correlation parameter in (-1,1)}
}
\value{
inverse matrix n x n of weights where code{n} is the total number of predictions 
(all the predictions for all the possible simulation chains)
}
\description{
get.matrix.Winv 
return the inverse matrix of W = V x C x V for the treatment of heteroscedastic and AR(1) errors
see Wang (2011) section 5.3 for further details
}
\references{
Wang, Y. 2011. 'Spline Smoothing with Heteroscedastic and/or Correlated Errors' 
Smoothing Splines. Chapman and Hall/CRC. https://doi.org/10.1201/b10954-11.
}
\author{
Guillaume Evin
}
