% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qm_preview.R
\name{qm_preview}
\alias{qm_preview}
\title{Preview Input}
\usage{
qm_preview(ref, key, value)
}
\arguments{
\item{ref}{An \code{sf} object that serves as a master list of features}

\item{key}{Name of geographic id variable in the \code{ref} object to match input values to}

\item{value}{A vector of input values created with \code{qm_define}}
}
\value{
An interactive leaflet map with the features from the defined vector specified in \code{value}
    highlighted in red.
}
\description{
This function renders the input vector as a polygon shapefile using the leaflet package.
}
\examples{
\dontrun{
# load and format reference data
stl <- stLouis
stl <- dplyr::mutate(stl, TRACTCE = as.numeric(TRACTCE))

# create cluster
cluster <- qm_define(118600, 119101, 119300)

# preview cluster
qm_preview(ref = stl, key = TRACTCE, value = cluster)
}

}
\seealso{
\code{qm_define}
}
