% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete.R, R/quadmesh.R
\name{quadmesh}
\alias{quadmesh}
\alias{dquadmesh}
\alias{dquadmesh.default}
\alias{quadmesh.BasicRaster}
\alias{quadmesh.matrix}
\title{Create a quad-type mesh for use in rgl.}
\usage{
dquadmesh(
  x,
  z = x,
  na.rm = FALSE,
  ...,
  texture = NULL,
  texture_filename = NULL
)

\method{dquadmesh}{default}(
  x,
  z = x,
  na.rm = FALSE,
  ...,
  texture = NULL,
  texture_filename = NULL
)

quadmesh(x, z = x, na.rm = FALSE, ..., texture = NULL, texture_filename = NULL)

\method{quadmesh}{BasicRaster}(x, z = x, na.rm = FALSE, ..., texture = NULL, texture_filename = NULL)

\method{quadmesh}{matrix}(x, z = x, na.rm = FALSE, ..., texture = NULL, texture_filename = NULL)
}
\arguments{
\item{x}{raster object for mesh structure}

\item{z}{raster object for height values}

\item{na.rm}{remove quads where missing values?}

\item{...}{ignored}

\item{texture}{optional input RGB raster, 3-layers}

\item{texture_filename}{optional input file path for PNG texture}
}
\value{
mesh3d
}
\description{
Convert an object to a \code{mesh3d} (\code{\link[rgl:qmesh3d]{rgl::qmesh3d()}}) quadrangle mesh,
with methods for \code{\link[raster:raster]{raster::raster()}} and \code{matrix}.
}
\details{
\code{quadmesh()} generates the cell-based interpretation of a raster (AREA) but applies a continuous
interpretation of the values of the cells to each quad corner. \code{dquadmesh} splits the mesh and
applies a discrete interpretation directly. Loosely, the quadmesh is a continuous surface and the dquadmesh
is free-floating cells, but it's a little more complicated and depends on the options applied. (The interpolation)
applied in the quadmesh case is not entirely consistent.

The output is described as a mesh because it is a dense representation
of a continuous shape, in this case plane-filling quadrilaterals defined
by index of four of the available vertices.

The \code{z} argument defaults to the input \code{x} argument, though may be set to \code{NULL}, a constant
numeric value, or another raster. If the coordinate system of \code{z} and \code{x} don't match the z values
are queried by reprojection.

Any raster RGB object (3-layers, ranging in 0-255) may be used as
a \emph{texture} on the resulting mesh3d object. If \code{texture} is a palette raster it will be
auto-expanded to RGB.

It is not possible to provide rgl with an object of data for texture, it must be a PNG file and so
the in-memory \code{texture} argument is written out to PNG file (with a message). The location of the file
may be set explicitly with \code{texture_filename}.  Currently it's not possible to not use the \code{texture} object
in-memory.
}
\examples{
library(raster)
data(volcano)
r <- setExtent(raster(volcano), extent(0, 100, 0, 200))
qm <- quadmesh(r)
}
