% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idotplot.R
\name{idotplot}
\alias{idotplot}
\title{Interactive phenotype x genotype plot}
\usage{
idotplot(x, y, indID = NULL, group = NULL, chartOpts = NULL, digits = 5)
}
\arguments{
\item{x}{Vector of groups of individuals (e.g., a genotype)}

\item{y}{Numeric vector (e.g., a phenotype)}

\item{indID}{Optional vector of character strings, shown with tool tips}

\item{group}{Optional vector of categories for coloring points}

\item{chartOpts}{A list of options for configuring the chart.  Each
element must be named using the corresponding option.}

\item{digits}{Round data to this number of significant digits
before passing to the chart function. (Use NULL to not round.)}
}
\value{
An object of class \code{htmlwidget} that will
intelligently print itself into HTML in a variety of contexts
including the R console, within R Markdown documents, and within
Shiny output bindings.
}
\description{
Creates an interactive graph of phenotypes vs genotypes at a marker.
}
\examples{
n <- 100
g <- sample(LETTERS[1:3], n, replace=TRUE)
y <- rnorm(n, match(g, LETTERS[1:3])*10, 5)
\donttest{
idotplot(g, y)}

}
\seealso{
\code{\link{iplot}}, \code{\link{iplotPXG}}
}
\keyword{hplot}

