// Generated by CoffeeScript 1.9.1
var add_search_box, iplotMap;

iplotMap = function(widgetdiv, data, chartOpts) {
  var axispos, chartdivid, chr, clean_marker_name, div, height, i, len, linecolor, linecolorhilit, linewidth, margin, marker, markerSelect, markerpos, martip, mychart, nyticks, rectcolor, ref, ref1, ref10, ref11, ref12, ref13, ref14, ref15, ref16, ref17, ref2, ref3, ref4, ref5, ref6, ref7, ref8, ref9, selectedMarker, svg, tickwidth, title, titlepos, widgetid, width, xlab, ylab, ylim, yticks;
  width = (ref = chartOpts != null ? chartOpts.width : void 0) != null ? ref : 1000;
  height = (ref1 = chartOpts != null ? chartOpts.height : void 0) != null ? ref1 : 600;
  margin = (ref2 = chartOpts != null ? chartOpts.margin : void 0) != null ? ref2 : {
    left: 60,
    top: 40,
    right: 100,
    bottom: 40,
    inner: 10
  };
  axispos = (ref3 = chartOpts != null ? chartOpts.axispos : void 0) != null ? ref3 : {
    xtitle: 25,
    ytitle: 30,
    xlabel: 5,
    ylabel: 5
  };
  titlepos = (ref4 = chartOpts != null ? chartOpts.titlepos : void 0) != null ? ref4 : 20;
  ylim = (ref5 = chartOpts != null ? chartOpts.ylim : void 0) != null ? ref5 : null;
  nyticks = (ref6 = chartOpts != null ? chartOpts.nyticks : void 0) != null ? ref6 : 5;
  yticks = (ref7 = chartOpts != null ? chartOpts.yticks : void 0) != null ? ref7 : null;
  tickwidth = (ref8 = chartOpts != null ? chartOpts.tickwidth : void 0) != null ? ref8 : 10;
  rectcolor = (ref9 = chartOpts != null ? chartOpts.rectcolor : void 0) != null ? ref9 : "#E6E6E6";
  linecolor = (ref10 = chartOpts != null ? chartOpts.linecolor : void 0) != null ? ref10 : "slateblue";
  linecolorhilit = (ref11 = chartOpts != null ? chartOpts.linecolorhilit : void 0) != null ? ref11 : "Orchid";
  linewidth = (ref12 = chartOpts != null ? chartOpts.linewidth : void 0) != null ? ref12 : 3;
  title = (ref13 = chartOpts != null ? chartOpts.title : void 0) != null ? ref13 : "";
  xlab = (ref14 = chartOpts != null ? chartOpts.xlab : void 0) != null ? ref14 : "Chromosome";
  ylab = (ref15 = chartOpts != null ? chartOpts.ylab : void 0) != null ? ref15 : "Position (cM)";
  chartdivid = (ref16 = chartOpts != null ? chartOpts.chartdivid : void 0) != null ? ref16 : 'chart';
  mychart = mapchart().height(height - margin.top - margin.bottom).width(width - margin.left - margin.right).margin(margin).axispos(axispos).titlepos(titlepos).ylim(ylim).yticks(yticks).nyticks(nyticks).tickwidth(tickwidth).rectcolor(rectcolor).linecolor(linecolor).linecolorhilit(linecolorhilit).linewidth(linewidth).title(title).xlab(xlab).ylab(ylab);
  div = d3.select(widgetdiv);
  widgetid = div.attr("id");
  svg = div.select("svg").datum(data).call(mychart);
  markerpos = {};
  ref17 = data.chr;
  for (i = 0, len = ref17.length; i < len; i++) {
    chr = ref17[i];
    for (marker in data.map[chr]) {
      markerpos[marker] = {
        chr: chr,
        pos: data.map[chr][marker]
      };
    }
  }
  martip = d3.tip().attr('class', 'd3-tip #{widgetid}').html(function(d) {
    var pos;
    pos = d3.format(".1f")(markerpos[d].pos);
    return d + " (" + pos + ")";
  }).direction('e').offset([0, 10]);
  svg.call(martip);
  clean_marker_name = function(markername) {
    return markername.replace(".", "\\.").replace("#", "\\#").replace("/", "\\/");
  };
  selectedMarker = "";
  $("div#markerinput_" + widgetid).submit(function() {
    var line, newSelection;
    newSelection = document.getElementById("marker_" + widgetid).value;
    event.preventDefault();
    if (selectedMarker !== "") {
      div.select("line#" + (clean_marker_name(selectedMarker))).attr("stroke", linecolor);
      martip.hide();
    }
    if (newSelection !== "") {
      if (data.markernames.indexOf(newSelection) >= 0) {
        selectedMarker = newSelection;
        line = div.select("line#" + (clean_marker_name(selectedMarker))).attr("stroke", linecolorhilit);
        martip.show(line.datum(), line.node());
        div.select("a#currentmarker").text("");
        return true;
      } else {
        div.select("a#currentmarker").text("Marker \"" + newSelection + "\" not found");
      }
    }
    return false;
  });
  $("input#marker_" + widgetid).autocomplete({
    autoFocus: true,
    source: function(request, response) {
      var matches;
      matches = $.map(data.markernames, function(tag) {
        if (tag.toUpperCase().indexOf(request.term.toUpperCase()) === 0) {
          return tag;
        }
      });
      return response(matches);
    },
    select: function(event, ui) {
      $("input#marker_" + widgetid).val(ui.item.label);
      return $("input#submit_" + widgetid).submit();
    }
  });
  $("input#marker_" + widgetid).each(function() {
    $("div.searchbox#markerinput_" + widgetid).addClass('inactive');
    return $(this).data('default', $(this).val()).focus(function() {
      $("div.searchbox#markerinput_" + widgetid).removeClass('inactive');
      if ($(this).val() === $(this).data('default') || $(this).val() === '') {
        return $(this).val('');
      }
    }).blur(function() {
      if ($(this).val() === '') {
        $("div.searchbox#markerinput_" + widgetid).addClass('inactive');
        return $(this).val($(this).data('default'));
      }
    });
  });
  markerSelect = mychart.markerSelect();
  return markerSelect.on("mouseover", function() {
    if (selectedMarker !== "") {
      div.select("line#" + (clean_marker_name(selectedMarker))).attr("stroke", linecolor);
      return martip.hide();
    }
  });
};

add_search_box = function(widgetdiv) {
  var div, form, widgetid;
  div = d3.select(widgetdiv);
  widgetid = div.attr("id");
  form = div.append("div").attr("class", "searchbox").attr("id", "markerinput_" + widgetid).append("form").attr("name", "markerinput_" + widgetid);
  form.append("input").attr("id", "marker_" + widgetid).attr("type", "text").attr("value", "Marker name").attr("name", "marker");
  form.append("input").attr("type", "submit").attr("id", "submit_" + widgetid).attr("value", "Submit");
  return form.append("a").attr("id", "currentmarker");
};
