% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractLT.R
\name{extractLT}
\alias{extractLT}
\alias{extractLTpwr}
\title{Obtain complete set of LT or LD estimates}
\usage{
extractLT(
  obj,
  a = 1:3,
  b = 4:6,
  link = NULL,
  logscale = FALSE,
  p = 0.99,
  eps = 0,
  offset = 0,
  df.t = NULL
)

extractLTpwr(
  obj,
  a = 1:3,
  b = 1:3,
  link = "fpower",
  logscale = FALSE,
  p = 0.99,
  lambda = 0,
  eps = 0.015,
  offset = 0,
  df.t = NULL
)
}
\arguments{
\item{obj}{\code{merMod} object, created using \code{lmer()} or
\code{glmerMod} object, created using \code{glmer()}.}

\item{a}{Subscripts for intercepts.}

\item{b}{Subscripts for corresponding slopes.}

\item{link}{Link function, for use with objects where no
link was specified in the function call, but it is required
to back-transform a transformation that was performed prior
to the function call.  Otherwise leave as `link=NULL`, and
the link function will be extracted as `family(obj)[['link']]`.
For a folded power function, with `extractLTpwr()`, the only
available link is "fpower", and the exponent `lambda` must be
specified.}

\item{logscale}{Logical.  Specify \code{TRUE}, if LT values are
to be back-transformed from a logarithmic scale.}

\item{p}{Target response proportion.}

\item{eps}{Replace \code{prob} by \code{prob+eps} before transformation.}

\item{offset}{Use to undo scaling of time or dose variable. This is
passed to the \code{\link{fieller}} function that \code{extractLT}
calls.}

\item{df.t}{Degrees of freedom for a t-distribution approximation
for `t` or `z` statistics.  If NULL, a conservative (low) value will
be used.  For linear (but not generalized linear) models and mixed
models, approximations are implemented in the \pkg{afex} package.
 See `vignette('introduction-mixed-models', package='afex')`, page 19.}

\item{lambda}{(\code{extractLTpwr} only) Power for power function.}
}
\value{
Matrix holding LD or LD estimates.
}
\description{
When supplied with a model object that has fitted
dose-response lines for each of several levels of a factor,
`extractLT` calls the function `fieller` to calculate lethal time
}
\details{
Fixed coefficients from `obj` must be for intercepts and
for slopes.  Starting the model formula with `0+` will commonly
do what is required. The coefficients `fixef(obj)[a]` are assumed
to specify line intercepts, while `fixef(obj)[b]` specify the
corresponding slopes.  These replace the arguments `nEsts`
(subscripts for intercepts were `1:nEsts`) and `slopeAdd`
(subscripts for slopes were `(nEsts+1):(nEsts+slopeAdd)`).
}
\examples{
form <- cbind(dead,total-dead)~0+Cultivar/dose+(1|cultRep)
codling1989.TMB <- glmmTMB::glmmTMB(formula=form,
  family=glmmTMB::betabinomial(link='cloglog'),
  dispformula=~0+Cultivar/splines::ns(dose,2),
  data=subset(codling1989,dose>0))
round(qra::extractLT(codling1989.TMB, a=1:3, 4:6),1)

}
