% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic_statistics.R
\name{adjLD}
\alias{adjLD}
\title{LD pruning of summary statistics}
\usage{
adjLD(
  stat = NULL,
  Glist = NULL,
  chr = NULL,
  statistics = "p-value",
  r2 = 0.9,
  ldSets = NULL,
  threshold = 1,
  method = "pruning"
)
}
\arguments{
\item{stat}{A data frame with marker summary statistics. Ensure that it is in the correct format.}

\item{Glist}{List of information about the genotype matrix stored on disk.}

\item{chr}{Chromosome(s) being processed.}

\item{statistics}{Specify what type of statistics ("b", "z", or "p-value") is being processed. Default is "p-value".}

\item{r2}{Threshold used in the clumping/pruning procedure. Default is 0.9.}

\item{ldSets}{List of marker sets - names correspond to row names in `stat`.}

\item{threshold}{P-value threshold used in LD pruning.}

\item{method}{Method used in adjustment for linkage disequilibrium. Options are "pruning" or "clumping". Default is "pruning".}
}
\description{
Perform LD pruning of summary statistics before they are used in gene set enrichment analyses.
}
\keyword{internal}
