% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa4.0.R
\name{qspec.lw}
\alias{qspec.lw}
\title{Lag-Window (LW) Estimator of Quantile Spectrum}
\usage{
qspec.lw(
  y,
  tau,
  y.qacf = NULL,
  M = NULL,
  method = c("none", "gamm", "sp"),
  spar = "GCV",
  n.cores = 1,
  cl = NULL
)
}
\arguments{
\item{y}{vector or matrix of time series (if matrix, \code{nrow(y)} = length of time series)}

\item{tau}{sequence of quantile levels in (0,1)}

\item{y.qacf}{matrix or array of pre-calculated QACF (default = \code{NULL}: compute from \code{y} and \code{tau});
if \code{y.qacf} is supplied, \code{y} and \code{tau} can be left unspecified}

\item{M}{bandwidth parameter of lag window (default = \code{NULL}: quantile periodogram)}

\item{method}{quantile smoothing method:  \code{"gamm"} for \code{mgcv::gamm()}, 
\code{"sp"} for \code{stats::smooth.spline()}, or \code{"none"} (default)}

\item{spar}{smoothing parameter in \code{smooth.spline()} if \code{method = "sp"} (default = \code{"GCV"})}

\item{n.cores}{number of cores for parallel computing (default = 1)}

\item{cl}{pre-existing cluster for repeated parallel computing (default = \code{NULL})}
}
\value{
A list with the following elements:
  \item{spec}{matrix or array of spectral estimate}
  \item{spec.lw}{matrix or array of spectral estimate without quantile smoothing}
  \item{lw}{lag-window sequence}
  \item{qacf}{matrix or array of quantile autocovariance function if \code{y.qacf = NULL}}
}
\description{
This function computes lag-window (LW) estimate of quantile spectrum
with or without quantile smoothing from time series or quantile autocovariance function (QACF).
}
\examples{
y1 <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
y2 <- stats::arima.sim(list(order=c(1,0,0), ar=-0.5), n=64)
tau <- seq(0.1,0.9,0.05)
n <- length(y1)
ff <- c(0:(n-1))/n
sel.f <- which(ff > 0 & ff < 0.5)
y.qacf <- qacf(cbind(y1,y2),tau)
y.qper.lw <- qspec.lw(y.qacf=y.qacf,M=5)$spec
qfa.plot(ff[sel.f],tau,Re(y.qper.lw[1,1,sel.f,]))
y.qper.lwqs <- qspec.lw(y.qacf=y.qacf,M=5,method="sp",spar=0.9)$spec
qfa.plot(ff[sel.f],tau,Re(y.qper.lwqs[1,1,sel.f,]))
}
