% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_assessment.R
\name{assessment}
\alias{assessment}
\title{Assessment measures of quantile composite-based path modeling}
\usage{
assessment(qcpm)
}
\arguments{
\item{qcpm}{is an object of class \code{qcpm}}
}
\value{
\item{Communality}{Communality of each MV. It is the proportion of the MV 
variance explained by the corresponding construct.}

\item{Block_Communality}{Communality of a whole block. It is computed 
as average of the MV communalities belonging to that block.}

\item{Redundancy}{Redundancy of each MV of the endogenous blocks. It measures 
the percent of the variance of MVs in endogenous blocks that is predicted from the 
explanatory constructs related to the endogenous construct.}

\item{Block_Redundancy}{Redundancy of a block. It is computed as average of 
MV redundancies belonging to that block.}

\item{pseudo.R2}{The \eqn{pseudo-R^2}. It assesses the goodness of fit of the inner 
model.}
}
\description{
\code{assessment} returns the following measures for assessing both the inner 
and the outer model: communality of each manifest variable, communality of 
each block,redundancy of each manifest variable of endogenous blocks, redundancy 
of the endogenous blocks, and \eqn{pseudo-R^2} for each inner equation.
}
\details{
All the assessment measures discussed in Davino et al. (2016) and Dolce et al. (2021) 
are based on \eqn{pseudo-R^2}, proposed by Koenker and Machado (1999), which simulates the 
role and interpretation of the \eqn{R^2} in classical regression analysis. The \eqn{pseudo-R^2} is 
considered as a local measure of goodness of fit for a particular quantile as it measures 
the contribute of the selected regressors to the explanation of the dependent variable, 
with respect to the trivial model without regressors. In more technical way, \eqn{pseudo-R^2}
compares the residual absolute sum of weighted differences using the selected model with 
the total absolute sum of weighted differences using a model with the only intercept. 
The \eqn{pseudo-R^2} can be used to assess the inner model measuring the amount of variability of a 
given endogenous construct explained by its explanatory constructs. A synthesis of the 
evaluations regarding the whole inner model can be obtained by the average of all the \eqn{pseudo-R^2}. 
Communality indicates how much of the MV variance is explained by the corresponding construct. 
It can be calculated for each MV, and for each block, using the average of MV communalities. 
Redundancy measures the percent of the variance of MVs in an endogenous block that is predicted 
from the explanatory constructs related to the endogenous construct. Redundancy can be computed 
only for each MVs of endogenous blocks and for the whole endogenous blocks, using the average of 
MV redundancies. Results are provided for each quantile of interest. When \code{fix.quantile=TRUE}, the 
function returns communalities and redundancies only for the quantile 0.5.
}
\examples{

# Example of QC-PM in Well-Being analysis
# model with three LVs and reflective indicators

# load library and dataset province
library(qcpm)
data(province)

# Define the model using laavan sintax. Use a set of regression formulas defining 
# firstly the structural model and then the measurement model
model <- "
ECOW ~ EDU
HEALTH ~ EDU + ECOW

# Reflective measurement model
EDU =~ EDU1 + EDU2 + EDU3 + EDU4 + EDU5 + EDU6 + EDU7
ECOW =~ ECOW1 + ECOW2 + ECOW3 + ECOW4 + ECOW5 + ECOW6
HEALTH =~  HEALTH1 + HEALTH2 + HEALTH3
"


# Apply qcpm
well.qcpm = qcpm(model,province)
well.assessment = assessment(well.qcpm)   
well.assessment 

}
\references{
Davino, C., Dolce, P., Taralli, S. and Vistocco, D. (2020). Composite-based 
path modeling for conditional quantiles prediction. An application to assess 
health differences at local level in a well-being perspective.
\emph{Social Indicators Research}, doi:10.1007/s11205-020-02425-5..

Davino, C. and Esposito Vinzi, V. (2016). Quantile composite-based path modeling. 
\emph{Advances in Data Analysis and Classification}, \bold{10 (4)}, pp. 
491--520, doi:10.1007/s11634-015-0231-9.

Davino, C., Esposito Vinzi, V. and Dolce, P. (2016). Assessment and validation in 
quantile composite-based path modeling. In: Abdi H.,  Esposito Vinzi, V., Russolillo, G., 
Saporta, G., Trinchera, L. (eds.). \emph{The Multiple Facets of Partial Least Squares Methods}, 
chapter 13. Springer proceedings in mathematics and statistics. Springer, Berlin

Dolce, P., Davino, C. and Vistocco, D. (2021). Quantile composite-based path modeling: 
algorithms, properties and applications. \emph{Advances in Data Analysis and Classification},
doi:10.1007/s11634-021-00469-0.

Koenker, R. and Machado, J.A. (1999). Goodness of fit and related inference processes 
for quantile regression. \emph{Journal of the American Statistical Association}, \bold{94 (448)} 
pp. 1296--1310, doi: 10.1080/01621459.1999.10473882

He, X.M. and Zhu, L.X. (2003). A lack-of-fit test for quantile regression. 
\emph{Journal of the American Statistical Association} \bold{98} pp. 1013--1022, 
doi: 10.1198/016214503000000963
}
\seealso{
\code{\link{summary}}, \code{\link{qcpm}}, \code{\link{boot}}, and 
\code{\link{reliability}}
}
\author{
Cristina Davino, Pasquale Dolce, Giuseppe Lamberti, Domenico Vistocco
}
