% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetQualificationType.R
\name{GetQualificationType}
\alias{GetQualificationType}
\alias{qualtype}
\title{Get QualificationType}
\usage{
GetQualificationType(qual, verbose = getOption("pyMTurkR.verbose", TRUE))
}
\arguments{
\item{qual}{A character string containing a QualificationTypeId.}

\item{verbose}{Optionally print the results of the API request to the
standard output. Default is taken from \code{getOption('pyMTurkR.verbose',
TRUE)}.}
}
\value{
A data frame containing the QualificationTypeId of the newly created
QualificationType and other details as specified in the request.
}
\description{
Get the details of a Qualification Type.
}
\details{
Retrieve characteristics of a specified QualificationType (as originally
specified by \code{\link{CreateQualificationType}}).

\code{qualtype()} is an alias.
}
\examples{

\dontrun{
qual1 <- CreateQualificationType(name="Worked for me before",
    description="This qualification is for people who have worked for me before",
    status = "Active",
    keywords="Worked for me before")
GetQualificationType(qual1$QualificationTypeId)
DisposeQualificationType(qual1$QualificationTypeId)
}

}
\references{
\href{https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetQualificationTypeOperation.html}{API Reference}
}
\author{
Tyler Burleigh, Thomas J. Leeper
}
\keyword{Qualifications}
