% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_df.R
\name{df.cod}
\alias{df.cod}
\title{Create a data frame for Crossover design}
\usage{
df.cod(treatments, label, squares)
}
\arguments{
\item{treatments}{An integer-valued vector specifying the treatment structure,
in which the length of the vector indicates the number of treatment factors,
and each value represents the number of levels for each factor. A maximum of
two factors is allowed, and they are arranged in a factorial design.
For instance, \code{treatments = n} specifies one treatment factor with n
levels, and \code{treatments=c(2,3)} creates a "2x3" factorial design of
two treatment factors with 2 and 3 levels, respectively.}

\item{label}{Optional. A list of character vectors specifying the names of
treatment factors and factor levels. Each vector in the list represents a
treatment factor, where the name of the vector specifies the name of the
factor, and the values in the vector are the labels for that factor's levels.
If not provided, factors and levels for one and two treatment factors are
labeled as \code{list(trt = c("1", "2", ...))} and
\code{list(facA = c("1", "2", ...), facB = c("1", "2", ...))}, respectively.}

\item{squares}{The number of replicated squares. By default, 1, i.e., no
replicated squares.}
}
\value{
a data.frame with columns for treatment factors, individuals (row block factor), period (column block factor), and squares
}
\description{
Create a data frame for Crossover design
}
