% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmApiRequest.R
\name{pmApiRequest}
\alias{pmApiRequest}
\title{Gather bibliographic content from PubMed database using NCBI entrez APIs}
\usage{
pmApiRequest(query, limit, api_key = NULL)
}
\arguments{
\item{query}{is a character. It contains a search query formulated using the Entrez query language.}

\item{limit}{is numeric. It indicates the max number of records to download.}

\item{api_key}{is a character. It contains a valid api key API keys for the NCBI E-utilities.}
}
\value{
a list D composed by 5 objects:
\tabular{lll}{
data \tab \tab It is the xml-structured list containing the bibliographic metadata collection downloaded from the PubMed database.\cr
query \tab \tab It a character object containing the original query formulated by the user.\cr
query_translation \tab \tab It a character object containing the query, translated by the NCBI Automatic Terms Translation system and submitted to the PubMed database.\cr
records_downloaded \tab \tab It is an integer object indicating the total number of records downloaded and stored in "data".\cr
total_counts \tab \tab It is an integer object indicating the total number of records matching the query (stored in the "query_translation" object").}

To obtain a free access to NCBI API, please visit: \href{https://www.ncbi.nlm.nih.gov/pmc/tools/developers/}{https://www.ncbi.nlm.nih.gov/pmc/tools/developers/}

To obtain more information about how to write a NCBI search query, please visit: \href{https://pubmed.ncbi.nlm.nih.gov/help/#search-tags}{https://pubmed.ncbi.nlm.nih.gov/help/#search-tags}
}
\description{
It gathers metadata about publications from the NCBI PubMed database.
The use of NCBI PubMed APIs is entirely free, and doesn't necessary require an API key.
The function \code{pmApiRequest} queries NCBI PubMed using an entrez query formulated through the function \code{pmQueryBuild}.
}
\details{
Official API documentation is \href{https://www.ncbi.nlm.nih.gov/books/NBK25500/}{https://www.ncbi.nlm.nih.gov/books/NBK25500/}.
}
\examples{

\donttest{
query <- query <- "bibliometric*[Title/Abstract] AND english[LA]
                    AND Journal Article[PT] AND 2000:2020[DP]"
 D <- pmApiRequest(query = query, limit = 100, api_key = NULL)
}

}
\seealso{
\code{\link{pmQueryTotalCount}}

\code{\link{pmApi2df}}
}
