% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pareto_test}
\alias{pareto_test}
\title{Goodness of Fit Test for Pareto Distribution}
\usage{
pareto_test(dat)
}
\arguments{
\item{dat}{vector of observations}
}
\value{
A list of the following form:
\describe{
  \item{p-value}{p-value indicating significance of the test}
}
}
\description{
The pareto_test function can be used to identify whether the data is 
Pareto distributed (Gulati and Shapiro 2008). The test generates a p-value 
corresponding to the actual distribution of the data and is tested for 
significance. In the case of Pareto data, the p-value should be greater 
than the pre-determined significance level (generally taken as 0.05).
}
\examples{
x <- generate_pareto(10000, 5, 2)
pareto_test(x)
}
\references{
Gulati S, Shapiro S (2008). "Goodness-of-Fit Tests for Pareto 
Distribution." In F Vonta (ed.), Statistical Models and Methods for 
Biomedical and Technical Systems, chapter 19, pp. 259-274. Birkhauser 
Basel. ISBN 978-0-8176-4619-6. doi:10.1007/978-0-8176-4619-6.
}
