% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetFitHRegL1.R
\name{GetFitHRegL1}
\alias{GetFitHRegL1}
\title{Compute loglikelihood ratio test statistic under the laplace noises}
\usage{
GetFitHRegL1(y)
}
\arguments{
\item{y}{Vector containing the series.}
}
\value{
Vector of length 2 containing 
the -2 loglikelihood ratio test statistic under the laplace noises 
and the estimated frequency.
}
\description{
The -2 loglikelihood ratio test statistic, -2LLR, is computed 
for testing for periodicity under the laplace noises.
}
\details{
To compute the likelihood ratio statistic, 
a harmonic regression model is fitted by 
the maximum likelihood estimations (MLE)
according to the selected model. In particular, the frequency f is found by 
the grid search among 
\eqn{En = {j/101 | j=1,\dots,50 and j/101 \ge 1/n}}.
The MLE is equivalent to 
the least absolute estimation. 
The computation is completed by the Exterior Point Methods 
with theimported function \code{\link{rq.fit.br}} 
from the package \code{quantreg}.
}
\author{
Yuanhao Lai
}
\references{
Li, T. H. (2010). A nonlinear method for robust spectral analysis. 
Signal Processing, IEEE Transactions on, 58(5), 2466-2474.
}
\keyword{internal}

