% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptive-utils.R
\name{sum_xna}
\alias{sum_xna}
\alias{mean_xna}
\alias{median_xna}
\alias{iqr_xna}
\alias{sd_xna}
\alias{var_xna}
\title{Descriptive statistics for variables with missing values}
\usage{
sum_xna(...)

mean_xna(...)

median_xna(...)

iqr_xna(...)

sd_xna(...)

var_xna(...)
}
\arguments{
\item{...}{Arguments to a descriptive statistic function}
}
\value{
A numeric vector, usually with one element, that provides the result
of a descriptive statistics function applied to a vector after the \code{NA}
values have been removed.
}
\description{
Most descriptive statistic function like \code{\link[base:sum]{base::sum()}}, \code{\link[base:mean]{base::mean()}},
\code{\link[stats:median]{stats::median()}}, etc., do not skip \code{NA} values when computing the results
and so always return \code{NA} if there is at least one \code{NA} in the input vector.
The \code{NA} values can be skipped always by setting the \code{na.rm} argument to
\code{TRUE}. While this is simply to do usually, in some cases, such as when a
function is being passed to another function, setting \code{na.rm = TRUE} in that
function requires creating a new anonymous function. The functions here,
which all end in \verb{_xna}, are wrappers to common statistics functions, but
with \code{na.rm = TRUE}.
}
\section{Functions}{
\itemize{
\item \code{mean_xna}: The arithmetic mean for vectors with missing values.

\item \code{median_xna}: The median for vectors with missing values.

\item \code{iqr_xna}: The interquartile range for vectors with missing values.

\item \code{sd_xna}: The standard deviation for vectors with missing values.

\item \code{var_xna}: The variance for vectors with missing values.
}}

\examples{
set.seed(10101)
# Make a vector of random numbers
x <- runif(10, min = 10, max = 20)
# Concatenate with a NA value
x1 <- c(NA, x)
sum(x)
sum(x1) # Will be NA
sum_xna(x1) # Will be same as sum(x)
stopifnot(sum_xna(x1) == sum(x))
stopifnot(mean_xna(x1) == mean(x))
stopifnot(median_xna(x1) == median(x))
stopifnot(iqr_xna(x1) == IQR(x))
stopifnot(sd_xna(x1) == sd(x))
stopifnot(var_xna(x1) == var(x))

}
