% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper-functions.R
\name{term_score}
\alias{term_score}
\title{Compute term-scores for each word-topic pair}
\usage{
term_score(beta_)
}
\arguments{
\item{beta_}{A \eqn{K} x \eqn{V} matrix of \eqn{V} vocabulary probabilities
for each of \eqn{K} topics.}
}
\value{
A \eqn{K} x \eqn{V} matrix of term-scores (comparable to tf-idf).
}
\description{
For more details, see Blei, D. M., & Lafferty, J. D. (2009). Topic models. In
A. N. Srivastava & M. Sahami (Eds.), Text mining: Classification, clustering,
and applications. Chapman and Hall/CRC.
}
\examples{

#' library(lda) # Required if using `prep_docs()`

data(teacher_rate)  # Synthetic student ratings of instructors
docs_vocab <- prep_docs(teacher_rate, "doc")
vocab_len <- length(docs_vocab$vocab)
m1 <- gibbs_sldax(rating ~ I(grade - 1), m = 2,
                  data = teacher_rate, docs = docs_vocab$documents,
                  V = vocab_len, K = 2, model = "sldax")
hbeta <- est_beta(m1)
ts_beta <- term_score(hbeta)
# One row per topic, one column per unique term in the vocabulary
str(ts_beta)

}
