% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.fa.R
\name{analyze.fa}
\alias{analyze.fa}
\title{Analyze fa objects.}
\usage{
\method{analyze}{fa}(x, labels = NULL, treshold = "max", ...)
}
\arguments{
\item{x}{An psych object.}

\item{labels}{Supply a additional column with e.g. item labels.}

\item{treshold}{'max' or numeric. The treshold over which to associate an item with its component.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
output
}
\description{
Analyze fa objects.
}
\examples{
library(psycho)
library(psych)

x <- psych::fa(psych::Thurstone.33, 2)

results <- analyze(x)
print(results)
summary(results)
plot(results)
}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
