% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychmeta.R
\docType{package}
\name{psychmeta-package}
\alias{psychmeta}
\alias{psychmeta-package}
\title{\pkg{psychmeta}: Psychometric meta-analysis toolkit}
\description{
Overview of the \pkg{psychmeta} package.
}
\details{
The \pkg{psychmeta} package provides tools for computing bare-bones and psychometric meta-analyses and for generating psychometric data for use in meta-analysis simulations. Currently, \pkg{psychmeta} supports bare-bones, individual-correction, and artifact-distribution methods for meta-analyzing correlations and \emph{d} values.
Please refer to the overview tutorial vignette for an introduction to \pkg{psychmeta}'s functions and workflows.
}
\section{Running a meta-analysis}{

The main functions for conducting meta-analyses in \pkg{psychmeta} are \code{\link{ma_r}} for correlations and \code{\link{ma_d}} for \emph{d} values. These functions take meta-analytic dataframes including effect sizes and sample sizes (and, optionally, study labels, moderators, construct and measure labels, and psychometric artifact information) and return the full results of psychometric meta-analyses for all of the specified variable pairs. Examples of correctly formatted meta-analytic datasets for ma functions are \code{\link{data_r_roth_2015}}, \code{\link{data_r_gonzalezmule_2014}}, and \code{\link{data_r_mcdaniel_1994}}. Individual parts of the meta-analysis process can also be run separately; these functions are described in detail below.
}

\section{Preparing a database for meta-analysis}{

The \code{\link{convert_es}} function can be used to convert a variety of effect sizes to either correlations or \emph{d} values. Sporadic psychometric artifacts, such as artificial dichotomization or uneven splits for a \emph{truly} dichotomous variable, can be individually corrected using \code{\link{correct_r}} and \code{\link{correct_d}}. These functions can also be used to compute confidence intervals for observed, converted, and corrected effect sizes. 'Wide' meta-analytic coding sheets can be reformatted to the 'long' data frames used by \pkg{psychmeta} with \code{\link{reshape_wide2long}}. A correlation matrix and accompanying vectors of information can be similarly reformatted using \code{\link{reshape_mat2dat}}.
}

\section{Meta-analytic models}{

\pkg{psychmeta} can compute barebones meta-analyses (no corrections for psychometric artifacts), as well as models correcting for measurement error in one or both variables, univariate direct (Case II) range restriction, univariate indirect (Case IV) range restriction, bivariate direct range restriction, bivariate indirect (Case V) range restriction, and multivariate range restriction. Artifacts can be corrected individually or using artifact distributions. Artifact distribution corrections can be applied using either Schmidt and Hunter's (2015) interactive method or Taylor series approximation models. Meta-analyses can be computed using various weights, including sample size (default for correlations), inverse variance (computed using either sample or mean effect size; error based on mean effect size is the default for \emph{d} values), and weight methods imported from \pkg{metafor}.
}

\section{Preparing artifact distributions meta-analyses}{

For individual-corrections meta-analyses, reliability and range restriction (u) values should be supplied in the same data frame as the effect sizes and sample sizes. Missing artifact data can be imputed using either bootstrap or other imputation methods. For artifact distribution meta-analyses, artifact distributions can be created automatically by \code{\link{ma_r}} or \code{\link{ma_d}} or manually by the \code{\link{create_ad}} family of functions.
}

\section{Moderator analyses}{

Subgroup moderator analyses are run by supplying a moderator matrix to the \code{\link{ma_r}} or \code{\link{ma_d}} families of functions. Both simple and fully hierarchical moderation can be computed. Subgroup moderator analysis results are shown by passing an \code{ma_obj} to \code{print}(). Meta-regression analyses can be run using \code{\link{metareg}}.
}

\section{Reporting results and supplemental analyses}{

Meta-analysis results can be viewed by passing an ma object to \code{\link{summary}}. Bootstrap confidence intervals, leave one out analyses, and other sensitivity analyses are available in \code{\link{sensitivity}}. Supplemental heterogeneity statistics (e.g., \eqn{Q}, \eqn{I^{2}}{I^2}) can be computed using \code{\link{heterogeneity}}. Meta-analytic results can be converted between the \eqn{r} and \eqn{d} metrics using \code{\link{convert_ma}}. Each \code{ma_obj} contains a \pkg{metafor} \code{escalc} object in \code{ma$...$escalc} that can be passed to \pkg{metafor}'s functions for plotting, publication/availability bias, and other supplemental analyses. Second-order meta-analyses of correlations can be computed using \code{\link{ma_r_order2}}. Example second-order meta-analysis datasets from Schmidt and Oh (2013) are available.
Tables of meta-analytic results can be written as markdown, Word, HTML, or PDF files using the \code{\link{metabulate}} function, which exports near publication-quality tables that will typically require only minor customization by the user.
}

\section{Simulating psychometric meta-analyses}{

\pkg{psychmeta} can be used to run Monte Carlo simulations for different meta-analytic models. \code{\link{simulate_r_sample}} and \code{\link{simulate_d_sample}} simulate samples of correlations and \emph{d} values, respectively, with measurement error and/or range restriction artifacts. \code{\link{simulate_r_database}} and \code{\link{simulate_d_database}} can be used to simulate full meta-analytic databases of sample correlations and \emph{d} values, respecitively, with artifacts. Example datasets fitting different meta-analytic models simulated using these functions are available (\code{\link{data_r_meas}}, \code{\link{data_r_uvdrr}}, \code{\link{data_r_uvirr}}, \code{\link{data_r_bvdrr}}, \code{\link{data_r_bvirr}}, \code{\link{data_r_meas_multi}}, and \code{\link{data_d_meas_multi}}). Additional simulation functions are also available.
}

\seealso{
Useful links:
\itemize{
  \item Report bugs at \url{https://github.com/psychmeta/psychmeta/issues}
}

}
\author{
\strong{Maintainer}: Jeffrey A. Dahlke \email{jdahlke@humrro.org}

Authors:
\itemize{
  \item Brenton M. Wiernik \email{brenton@psychmeta.com}
}

Other contributors:
\itemize{
  \item Wesley Gardiner (Unit tests) [contributor]
  \item Michael T. Brannick (Testing) [contributor]
  \item Jack Kostal (Code for reshape_mat2dat function) [contributor]
  \item Sean Potter (Testing; Code for cumulative and leave1out plots) [contributor]
  \item John Sakaluk (Code for funnel and forest plots) [contributor]
  \item Yuejia (Mandy) Teng (Testing) [contributor]
}

}
