% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printTable.R
\name{printTable}
\alias{printTable}
\title{printTable}
\usage{
printTable(obj, caption = "DF", digits = 3, onlyContents = FALSE,
  formatStatsSymbols = TRUE)
}
\arguments{
\item{obj}{Dataframe/ezANOVA object to print}

\item{caption}{Title of the dataframe}

\item{digits}{Number of digits to round to}

\item{onlyContents}{TRUE/FALSE}

\item{formatStatsSymbols}{TRUE/FALSE}
}
\value{
character
}
\description{
Returns Latex formatted table from dataframe or ezANOVA ANOVA table.
Uses xtable latex package with some basic defaults.
For more examples, see R package xtable
}
\examples{
requiredPackages(c("dplyr", "ez"))
# Example 1:
# create dataframe
dat <- createDF(nVP = 6, nTrl = 1,
                design = list("Comp" = c("comp", "incomp")))

dat <- addDataDF(dat, RT = list(list(c("Comp:comp"), vals = c(500, 150, 100)),
                                list(c("Comp:incomp"), vals = c(520, 150, 100))))
printTable(dat) # latex formatted

aovRT <- ezANOVA(dat, dv=.(RT), wid = .(VP), within = .(Comp),
                 return_aov = TRUE, detailed = TRUE)
aovRT <- aovTable(aovRT)
printTable(aovRT$ANOVA) # latex formatted

\dontrun{
# Example use in *.Rnw Sweave file inside R chunk
# << printTable, echo = FALSE, results = tex >>=
# printTable(aovRT$ANOVA, caption = "ANOVA Table")
# @}

}
