% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.plr.R
\name{print.plr}
\alias{print.plr}
\title{Print method for Polygonal Linear Regression}
\usage{
\method{print}{plr}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{x}{the object to be printed.}

\item{digits}{a non-null value for \code{digits} specifies the minimum number of significant digits to be printed in values.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
\code{print.plr} is the \code{plr} method of the generic print function
which prints its argument.
}
\examples{
yp <- psim(10, 10) #simulate 10 polygons of 10 sides
xp1 <- psim(10, 10) #simulate 10 polygons of 10 sides
xp2 <- psim(10, 10) #simulate 10 polygons of 10 sides
e <- new.env()
e$yp <- yp
e$xp1 <- xp1
e$xp2 <- xp2
fit <- plr(yp~xp1 + xp2, data = e)
fit  
}
