% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/func_spec.R
\docType{methods}
\name{spec-methods}
\alias{as.data.frame.spec}
\alias{as.list.spec}
\alias{as.spec}
\alias{as.spec.amt}
\alias{data.frame.spec}
\alias{lines.spec}
\alias{spec-methods}
\title{Generic methods for objects with class \code{'spec'}}
\usage{
\method{as.list}{spec}(x, ...)

as.spec(x, ...)

\method{as.spec}{amt}(x, ...)

\method{lines}{spec}(x, y = NULL, type = "l", ...)

\method{as.data.frame}{spec}(x, ...)

data.frame.spec(x, ...)
}
\arguments{
\item{x}{a \code{'spec'} object}

\item{...}{optional arguments}

\item{y}{optional coordinate vector for the y-axis}

\item{type}{character; the type of plot}
}
\description{
Generic methods for objects with class \code{'spec'}
}
\details{
Objects with class \code{'spec'} are simply lists with spectral estimates and parameters
\code{as.data.frame} converts the list into a \code{'data.frame'} with individual
columns for the frequency, PSD, and taper vectors;
all other information will be retained as an attribute.
}
\examples{
\dontrun{#REX
library(psd)
##
## Objects with class 'spec'
##
set.seed(1234)
#
x <- spectrum(xn<-rnorm(10), plot=FALSE)
xdf <-as.data.frame(x)
str(xdf)
is.tapers(xdf$taper)
#
# tapers class is retained
#
x <- psdcore(xn)
xdf <- as.data.frame(x)
str(xdf)
is.tapers(xdf$taper)
}#REX
}
\author{
A.J. Barbour
}

