% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linPred.R
\name{linPred}
\alias{linPred}
\title{Estimates the linear predictor of a psc object}
\usage{
linPred(DC_clean, resp = FALSE)
}
\arguments{
\item{DC_clean}{a cleaned data obhject created using dataComb()}

\item{resp}{detailing whether the linear predictor shoudl be returned on the natural or response level.  Defaults to the natural scale (resp=F)}
}
\value{
Extracts the linear predictor from a object containing both a counter factual model and a data cohort which is created using the dataComb() fucntion.
}
\description{
A function which created a linear predictor from a model and an external
dataset.  If required, linear predictors will be provided on the response
scale.  For a survival outcome, this will take the form of median survival
estimates.
}
\details{
A function which combines the data from the data cohort against the model parameters of the PSC
}
\examples{
library(psc)
library(survival)
surv.mod <- psc::surv.mod
data <- psc::data
dc <- dataComb(surv.mod,data)
lp <- linPred(dc)
}
